<?php
ob_start();
error_reporting(0);
//===============//
define('API_KEY',"7789271152:AAFBTUG6_ueDPwh2WZbFqt2leTtjBHvbYSY");
//توکن را قرار دهید//
define('COINGECKO_NEWS_URL', 'https://api.coingecko.com/api/v3/news');
$newsApiKey = 'c14c7ffcb7824b2a8e7fc2927a70f8bf'; // کلید API خود را اینجا قرار دهید
$deepseekApiKey = 'sk-d20e6df2cda2489d96bc56f09849f667';
$binance_api_url = "https://api.binance.com/api/v3/klines";
define('NEWS_API_KEY', 'c14c7ffcb7824b2a8e7fc2927a70f8bf');
$popularSymbols = [
    'BTCUSDT', 'ETHUSDT', 'BNBUSDT', 'XRPUSDT', 'ADAUSDT',
    'DOGEUSDT', 'SOLUSDT', 'DOTUSDT', 'LTCUSDT', 'LINKUSDT',
    'MATICUSDT', 'AVAXUSDT', 'TRXUSDT', 'ATOMUSDT', 'UNIUSDT'
];
define('AIRDROP_TOKEN_AMOUNT', 1000); // مقدار توکن برای برداشت
define('AIRDROP_REFERRAL_MIN', 10);   // حداقل زیرمجموعه مورد نیاز
define('CRYPTO_PASSWORD', '123456'); // رمز عبور برای دسترسی به تحلیل کریپتو
define('DEEPSEEK_API_KEY', 'sk-d20e6df2cda2489d96bc56f09849f667');
$cryptoList = [
    "Bitcoin" => "BTCUSDT",
    "Ethereum" => "ETHUSDT",
    "Binance Coin" => "BNBUSDT",
    "XRP" => "XRPUSDT",
    "Cardano" => "ADAUSDT",
    "Dogecoin" => "DOGEUSDT",
    "Solana" => "SOLUSDT",
    "Polkadot" => "DOTUSDT",
    "Shiba Inu" => "SHIBUSDT",
    "Polygon" => "MATICUSDT",
    "Litecoin" => "LTCUSDT",
    "Chainlink" => "LINKUSDT",
    "Uniswap" => "UNIUSDT",
    "Avalanche" => "AVAXUSDT",
    "Tron" => "TRXUSDT",
    "Cosmos" => "ATOMUSDT",
    "Stellar" => "XLMUSDT",
    "Bitcoin Cash" => "BCHUSDT",
    "Filecoin" => "FILUSDT",
    "Internet Computer" => "ICPUSDT"
];
function fetchMarketStats($chatid) {
    try {
        // تنظیمات درخواست به API نوبیتکس
        $url = 'https://api.nobitex.ir/market/stats';
        $data = [
            'srcCurrency' => 'btc,eth,usdt,ltc,xrp,BCH,BNB,EOS,XLM,ETC,TRX,DOGe,mask', // ارزهای پایه (بیت‌کوین، اتریوم، تتر)
            'dstCurrency' => 'rls' // ارز مقصد (ریال)
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode !== 200) {
            throw new Exception("خطا در ارتباط با سرور نوبیتکس (کد: $httpCode)");
        }

        $result = json_decode($response, true);
        if ($result['status'] !== 'ok') {
            throw new Exception("خطا در پاسخ API: " . ($result['message'] ?? 'نامشخص'));
        }

        // پردازش داده‌ها
        $message = "📊 آخرین اطلاعات بازار نوبیتکس:\n\n";
        foreach ($result['stats'] as $market => $stats) {
            // تبدیل نام بازار به فرمت خوانا (مثلاً btc-rls به بیت‌کوین/ریال)
            $marketName = strtoupper(str_replace('-rls', '/ریال', $market));
            $latestPrice = number_format($stats['latest'], 0, '.', ',');
            $dayChange = round($stats['dayChange'], 2);
            $volumeSrc = round($stats['volumeSrc'], 4);
            $volumeDst = number_format($stats['volumeDst'], 0, '.', ',');
            $bestBuy = number_format($stats['bestBuy'], 0, '.', ',');
            $bestSell = number_format($stats['bestSell'], 0, '.', ',');

            $message .= "💱 $marketName\n";
            $message .= "آخرین قیمت: $latestPrice ریال\n";
            $message .= "تغییرات روزانه: $dayChange%\n";
            $message .= "حجم معاملات (ارز): $volumeSrc\n";
            $message .= "حجم معاملات (ریال): $volumeDst\n";
            $message .= "بهترین خرید: $bestBuy ریال\n";
            $message .= "بهترین فروش: $bestSell ریال\n";
            $message .= "بیشترین قیمت روز: " . number_format($stats['dayHigh'], 0, '.', ',') . " ریال\n";
            $message .= "کمترین قیمت روز: " . number_format($stats['dayLow'], 0, '.', ',') . " ریال\n";
            $message .= "──────────────────\n";
        }

        // ارسال پیام به کاربر
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => $message,
            'parse_mode' => 'Markdown'
        ]);

    } catch (Exception $e) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ خطا در دریافت اطلاعات بازار: " . $e->getMessage()
        ]);
        error_log("Market Stats Error: " . $e->getMessage(), 3, "data/errors.log");
    }
}
function takeWebsiteScreenshotAPI($url, $chatid, $apiKey) {
    try {
        // تنظیمات درخواست به API
        $apiUrl = "https://screenshotapi.net/api/v1/screenshot?token={$apiKey}&url={$url}&output=image&width=1280&height=720&fresh=true";
        
        // استفاده از cURL برای دریافت اسکرین‌شات
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        $response = curl_exec($ch);
        curl_close($ch);

        // ذخیره تصویر موقت
        $outputPath = sys_get_temp_dir() . "/screenshot_{$chatid}_" . time() . ".png";
        file_put_contents($outputPath, $response);

        // بررسی موفقیت و ارسال تصویر
        if (file_exists($outputPath) && filesize($outputPath) > 0) {
            bot('sendPhoto', [
                'chat_id' => $chatid,
                'photo' => new CURLFile(realpath($outputPath)),
                'caption' => "📸 اسکرین‌شات از $url در تاریخ " . date('Y-m-d H:i:s')
            ]);

            // حذف فایل موقت
            unlink($outputPath);
        } else {
            throw new Exception("فایل اسکرین‌شات خالی یا ناموفق بود.");
        }
    } catch (Exception $e) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ خطا در گرفتن اسکرین‌شات: " . $e->getMessage()
        ]);
        error_log("Screenshot API Error: " . $e->getMessage(), 3, "data/errors.log");
    }
}
// اضافه کردن تابع برای نمایش منوی فروشگاه NFT
function showNFTShopMenu($chatid, $messageid) {
    global $menu;

    // مسیر پوشه NFT
    $nftFolder = __DIR__ . '/NFT/';
    if (!is_dir($nftFolder)) {
        bot('editMessageText', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "⚠️ پوشه NFT یافت نشد! لطفاً پوشه را در مسیر ربات ایجاد کنید.",
            'reply_markup' => $menu
        ]);
        return;
    }

    // اسکن فایل‌ها در پوشه NFT
    $nftFiles = array_diff(scandir($nftFolder), ['..', '.']);
    $nftList = [];
    foreach ($nftFiles as $file) {
        if (in_array(strtolower(pathinfo($file, PATHINFO_EXTENSION)), ['png', 'jpg', 'jpeg'])) {
            $nftList[] = $file;
        }
    }

    if (empty($nftList)) {
        bot('editMessageText', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "⚠️ هیچ NFTی در پوشه یافت نشد!",
            'reply_markup' => $menu
        ]);
        return;
    }

    $text = "🛒 *فروشگاه NFT*\n\n📌 موجودی NFTها:\n";
    $keyboard = [];
    $row = [];

    $counter = 0;
    foreach ($nftList as $index => $nft) {
        $nftName = pathinfo($nft, PATHINFO_FILENAME);
        $text .= "🔹 NFT #$index: $nftName\n";
        $row[] = [
            'text' => "خرید NFT #$index (1000 توکن)",
            'callback_data' => "buy_nft_$index"
        ];
        $counter++;

        if ($counter % 2 == 0 || $counter == count($nftList)) {
            $keyboard[] = $row;
            $row = [];
        }
    }

    $keyboard[] = [['text' => "🔙 بازگشت", 'callback_data' => "back_to_menu"]];

    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => $text,
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);

    // ارسال تصاویر NFTها به‌صورت جداگانه
    foreach ($nftList as $index => $nft) {
        $photoPath = $nftFolder . $nft;
        bot('sendPhoto', [
            'chat_id' => $chatid,
            'photo' => new CURLFile(realpath($photoPath)),
            'caption' => "🖼️ NFT #$index: $nft\n💰 قیمت: 1000 توکن",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "خرید", 'callback_data' => "buy_nft_$index"]]
                ]
            ])
        ]);
    }
}
// مدیریت خرید NFT
// تابع مدیریت خرید NFT
function handleNFTPurchase($chatid, $messageid, $data) {
    global $menu;

    if (preg_match('/buy_nft_(\d+)/', $data, $matches)) {
        $nftIndex = $matches[1];
        $nftFolder = __DIR__ . '/NFT/';
        $nftFiles = array_diff(scandir($nftFolder), ['..', '.']);
        $nftList = array_filter($nftFiles, fn($file) => in_array(strtolower(pathinfo($file, PATHINFO_EXTENSION)), ['png', 'jpg', 'jpeg']));
        $nftList = array_values($nftList); // بازنشانی ایندکس‌ها

        if (!isset($nftList[$nftIndex])) {
            bot('sendMessage', [
                'chat_id' => $chatid,
                'text' => "❌ NFT انتخاب‌شده یافت نشد!"
            ]);
            return;
        }

        $nftName = pathinfo($nftList[$nftIndex], PATHINFO_FILENAME);
        $price = 1000; // قیمت ثابت برای هر NFT
        $userFile = "data/$chatid/user_data.json";
        $userData = file_exists($userFile) ? json_decode(file_get_contents($userFile), true) : ['coins' => 0];

        if ($userData['coins'] >= $price) {
            // کسر موجودی کاربر
            $userData['coins'] -= $price;
            file_put_contents($userFile, json_encode($userData));

            // ارسال پیام به کاربر
            bot('editMessageText', [
                'chat_id' => $chatid,
                'message_id' => $messageid,
                'text' => "✅ درخواست خرید NFT #$nftIndex ($nftName) ثبت شد!\n💰 $price توکن از موجودی شما کسر شد.\nدرخواست شما به پشتیبانی ارسال شد و پس از تأیید، NFT به شما تحویل داده می‌شود.",
                'reply_markup' => $menu
            ]);

            // ارسال پیام به کانال پشتیبانی
            $supportChannel = "@shanimony"; // جایگزین با آیدی کانال پشتیبانی
            $supportMessage = "📦 درخواست خرید NFT جدید:\n";
            $supportMessage .= "👤 کاربر: $chatid\n";
            $supportMessage .= "🎨 NFT: #$nftIndex ($nftName)\n";
            $supportMessage .= "💰 قیمت: $price توکن\n";
            $supportMessage .= "📅 زمان: " . date('Y-m-d H:i:s');

            bot('sendMessage', [
                'chat_id' => $supportChannel,
                'text' => $supportMessage
            ]);

            // ارسال تصویر NFT به پشتیبانی
            $photoPath = $nftFolder . $nftList[$nftIndex];
            bot('sendPhoto', [
                'chat_id' => $supportChannel,
                'photo' => new CURLFile(realpath($photoPath)),
                'caption' => "🖼️ NFT انتخاب‌شده توسط کاربر $chatid\nنام: $nftName"
            ]);

            // ثبت تراکنش در لاگ
            $transactionLog = "data/transactions.log";
            $logEntry = "[" . date('Y-m-d H:i:s') . "] User $chatid requested NFT #$nftIndex ($nftName) for $price tokens.\n";
            file_put_contents($transactionLog, $logEntry, FILE_APPEND);
        } else {
            bot('sendMessage', [
                'chat_id' => $chatid,
                'text' => "❌ موجودی شما کافی نیست! حداقل $price توکن نیاز است.\nموجودی فعلی: " . $userData['coins'] . " توکن"
            ]);
        }
    }
}

function calculateRenko($data, $brickSize = 10) {
    if (count($data) < 2) {
        return []; // داده کافی نیست
    }

    $renko = [];
    $lastBrickPrice = $data[0][4]; // قیمت بسته شدن اولین کندل
    $currentTrend = null; // 'up' یا 'down'

    for ($i = 1; $i < count($data); $i++) {
        $closePrice = $data[$i][4]; // قیمت بسته شدن کندل

        // بررسی اینکه آیا قیمت به اندازه brickSize تغییر کرده است
        while (abs($closePrice - $lastBrickPrice) >= $brickSize) {
            if ($closePrice > $lastBrickPrice) {
                $newBrickPrice = $lastBrickPrice + $brickSize;
                $trend = 'up';
            } else {
                $newBrickPrice = $lastBrickPrice - $brickSize;
                $trend = 'down';
            }

            if ($currentTrend !== $trend) {
                $renko[] = ['price' => $newBrickPrice, 'trend' => $trend];
                $currentTrend = $trend;
            }

            $lastBrickPrice = $newBrickPrice;
        }
    }

    return $renko;
}
function askDeepSeek($prompt, $apiKey) {
    $url = 'https://api.deepseek.com/v1/chat/completions';
    
    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey
    ];
    
    $data = [
        'model' => 'deepseek-chat',
        'messages' => [
            ['role' => 'user', 'content' => $prompt]
        ]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $result = curl_exec($ch);
    curl_close($ch);
    
    $response = json_decode($result, true);
    return $response['choices'][0]['message']['content'] ?? 'خطا در دریافت پاسخ';
}
function calculateHV($data, $period = 20) {
    if (count($data) < $period) {
        return null; // داده کافی نیست
    }

    $logReturns = [];
    
    for ($i = 1; $i < count($data); $i++) {
        $prevClose = $data[$i - 1][4]; // قیمت بسته شدن کندل قبلی
        $currentClose = $data[$i][4]; // قیمت بسته شدن کندل فعلی
        
        // محاسبه بازده لگاریتمی
        $logReturns[] = log($currentClose / $prevClose);
    }

    // محاسبه میانگین بازده‌ها
    $meanReturn = array_sum(array_slice($logReturns, -$period)) / $period;

    // محاسبه انحراف معیار بازده‌ها
    $variance = 0;
    for ($i = count($logReturns) - $period; $i < count($logReturns); $i++) {
        if (!isset($logReturns[$i])) continue;
        $variance += pow($logReturns[$i] - $meanReturn, 2);
    }

    $stdDev = sqrt($variance / $period);

    // تبدیل به درصد و تعدیل بر اساس ریشه دوم سالانه (۲۵۲ روز کاری)
    $hv = $stdDev * sqrt(252) * 100;

    return $hv;
}
function calculateCDV($data) {
    if (count($data) < 2) {
        return []; // داده کافی نیست
    }

    $cdv = [0]; // مقدار اولیه CDV
    for ($i = 1; $i < count($data); $i++) {
        $buyVolume = $data[$i]['buy_volume'];  // حجم سفارشات خرید بازار
        $sellVolume = $data[$i]['sell_volume']; // حجم سفارشات فروش بازار
        $delta = $buyVolume - $sellVolume; // اختلاف حجم خرید و فروش
        $cdv[] = end($cdv) + $delta; // مقدار CDV تجمعی
    }

    return $cdv;
}
function calculateZigZag($data, $percentThreshold = 5) {
    if (count($data) < 2) {
        return []; // داده کافی نیست
    }

    $zigzag = [];
    $lastPivot = 0;
    $trend = null; // 'up' یا 'down'

    for ($i = 1; $i < count($data); $i++) {
        $priceChange = (($data[$i][4] - $data[$lastPivot][4]) / $data[$lastPivot][4]) * 100;

        if ($trend === 'up' && $priceChange < -$percentThreshold) {
            $zigzag[] = ['index' => $lastPivot, 'price' => $data[$lastPivot][4]];
            $lastPivot = $i;
            $trend = 'down';
        } elseif ($trend === 'down' && $priceChange > $percentThreshold) {
            $zigzag[] = ['index' => $lastPivot, 'price' => $data[$lastPivot][4]];
            $lastPivot = $i;
            $trend = 'up';
        } elseif ($trend === null) {
            $trend = $priceChange > 0 ? 'up' : 'down';
        }
    }

    // آخرین نقطه را اضافه کنیم
    $zigzag[] = ['index' => $lastPivot, 'price' => $data[$lastPivot][4]];

    return $zigzag;
}
function generateHarmonicChart($ohlcv, $patterns) {
    require 'vendor/autoload.php'; // 引入图表库
    
    $chart = new \ChartJs\Chart();
    // 配置图表参数...
    
    // 保存临时图片
    $filename = tempnam(sys_get_temp_dir(), 'chart') . '.png';
    file_put_contents($filename, $chart->render());
    
    return $filename;
}
function detectHarmonicPatterns($ohlcv) {
    $patterns = [];
    
    // 实现谐波模式检测逻辑（示例：简单ABCD模式检测）
    for ($i=3; $i<count($ohlcv); $i++) {
        $current = $ohlcv[$i];
        $prev1 = $ohlcv[$i-1];
        $prev2 = $ohlcv[$i-2];
        $prev3 = $ohlcv[$i-3];
        
        // 简单ABCD模式检测逻辑
        if (isABCDPattern($prev3, $prev2, $prev1, $current)) {
            $patterns[] = [
                'type' => 'ABCD',
                'points' => [$prev3, $prev2, $prev1, $current],
                'confidence' => 0.85
            ];
        }
    }
    
    return $patterns;
}
function generateHarmonicAnalysis($patterns, $symbol, $timeframe) {
    $analysis = "📊 *تحلیل هارمونیک برای $symbol ($timeframe)*\n\n";
    
    if (empty($patterns)) {
        return $analysis . "⚠️ هیچ الگوی هارمونیک شناسایی نشد";
    }
    
    foreach ($patterns as $pattern) {
        $analysis .= "🔹 *الگوی " . $pattern['type'] . "*\n";
        $analysis .= "▫️ اعتبار: " . ($pattern['confidence']*100) . "%\n";
        $analysis .= "▫️ نقاط کلیدی:\n";
        
        foreach ($pattern['points'] as $point) {
            $price = $point[4]; // 收盘价
            $time = date("Y-m-d H:i", $point[0]/1000);
            $analysis .= "‌‌‎ ‎↪️ $time - قیمت: $price\n";
        }
        $analysis .= "\n";
    }
    
    $analysis .= "\n📌 *توصیه معاملاتی:*\n";
    $analysis .= "▫️ حد ضرر: 2% زیر آخرین نقطه\n";
    $analysis .= "▫️ هدف قیمت اول: 1:1 ریسک به بازده\n";
    $analysis .= "▫️ هدف قیمت دوم: 1:1.618 ریسک به بازده\n\n";
    $analysis .= "⚠️ این تحلیل صرفا آموزشی است و مسئولیتی پذیرفته نمی‌شود";
    
    return $analysis;
}
function calculateVWAP($data) {
    $vwap = [];
    $cumulativeVolume = 0;
    $cumulativeTypicalPriceVolume = 0;

    foreach ($data as $index => $candle) {
        $typicalPrice = ($candle[2] + $candle[3] + $candle[4]) / 3; // (High + Low + Close) / 3
        $volume = $candle[5]; // حجم معاملات

        $cumulativeVolume += $volume;
        $cumulativeTypicalPriceVolume += $typicalPrice * $volume;

        if ($cumulativeVolume > 0) {
            $vwap[$index] = $cumulativeTypicalPriceVolume / $cumulativeVolume;
        } else {
            $vwap[$index] = null;
        }
    }

    return $vwap;
}
function calculateHeikinAshiSmoothed($data) {
    if (count($data) < 2) {
        return []; // حداقل دو کندل نیاز است
    }

    $heikinAshi = [];
    
    // مقداردهی اولیه کندل اول
    $haOpen = ($data[0][1] + $data[0][4]) / 2;
    $haClose = ($data[0][1] + $data[0][2] + $data[0][3] + $data[0][4]) / 4;
    $haHigh = max($data[0][2], $haOpen, $haClose);
    $haLow = min($data[0][3], $haOpen, $haClose);

    $heikinAshi[] = [
        'open'  => $haOpen,
        'close' => $haClose,
        'high'  => $haHigh,
        'low'   => $haLow
    ];

    // محاسبه کندل‌های بعدی
    for ($i = 1; $i < count($data); $i++) {
        $open = $data[$i][1];
        $high = $data[$i][2];
        $low = $data[$i][3];
        $close = $data[$i][4];

        $haOpen = ($heikinAshi[$i - 1]['open'] + $heikinAshi[$i - 1]['close']) / 2;
        $haClose = ($open + $high + $low + $close) / 4;
        $haHigh = max($high, $haOpen, $haClose);
        $haLow = min($low, $haOpen, $haClose);

        $heikinAshi[] = [
            'open'  => $haOpen,
            'close' => $haClose,
            'high'  => $haHigh,
            'low'   => $haLow
        ];
    }

    return $heikinAshi;
}
function calculateRVI($data, $period = 10) {
    if (count($data) < $period) {
        return []; // داده کافی نیست
    }

    $numerator = [];
    $denominator = [];
    $rvi = [];

    for ($i = 0; $i < count($data); $i++) {
        if ($i < $period - 1) {
            $rvi[] = null;
            continue;
        }

        $sumNumerator = 0;
        $sumDenominator = 0;

        for ($j = 0; $j < $period; $j++) {
            $close = $data[$i - $j][4];
            $open = $data[$i - $j][1];
            $high = $data[$i - $j][2];
            $low = $data[$i - $j][3];

            $sumNumerator += ($close - $open);
            $sumDenominator += ($high - $low);
        }

        if ($sumDenominator == 0) {
            $rvi[] = 0;
        } else {
            $rvi[] = $sumNumerator / $sumDenominator;
        }
    }

    return $rvi;
}
function calculateADLine($data) {
    if (count($data) < 2) {
        return []; // داده کافی نیست
    }

    $adLine = [0]; // مقدار اولیه AD Line

    for ($i = 1; $i < count($data); $i++) {
        $close = $data[$i][4]; // قیمت بسته شدن
        $high = $data[$i][2];  // بالاترین قیمت
        $low = $data[$i][3];   // پایین‌ترین قیمت
        $volume = $data[$i][5]; // حجم معاملات

        // محاسبه Money Flow Multiplier
        $mfMultiplier = ($close - $low - ($high - $close)) / ($high - $low);
        if ($high == $low) {
            $mfMultiplier = 0; // جلوگیری از تقسیم بر صفر
        }

        // محاسبه Money Flow Volume
        $mfVolume = $mfMultiplier * $volume;

        // محاسبه AD Line تجمعی
        $adLine[] = end($adLine) + $mfVolume;
    }

    return $adLine;
}
function calculateFisherTransform($data, $period = 10) {
    if (count($data) < $period) {
        return []; // اگر داده کافی نباشد، مقدار خالی برگردانده شود.
    }

    $fisher = [];
    $normalizedPrice = [];

    for ($i = 0; $i < count($data); $i++) {
        if ($i < $period - 1) {
            $fisher[] = null;
            continue;
        }

        $slice = array_slice($data, $i - ($period - 1), $period);
        $highs = array_column($slice, 2); // بالاترین قیمت‌ها
        $lows = array_column($slice, 3);  // پایین‌ترین قیمت‌ها
        $midPrice = ($data[$i][2] + $data[$i][3]) / 2; // میانگین بالا و پایین قیمت

        $minLow = min($lows);
        $maxHigh = max($highs);
        $range = $maxHigh - $minLow;

        // جلوگیری از تقسیم بر صفر
        if ($range == 0) {
            $normalized = 0;
        } else {
            $normalized = (2 * (($midPrice - $minLow) / $range) - 1);
        }

        // محدود کردن مقدار نرمال‌شده به بازه‌ی -0.999 تا 0.999
        $normalized = max(-0.999, min(0.999, $normalized));
        $normalizedPrice[] = $normalized;

        // محاسبه Fisher Transform
        if ($i == 0) {
            $fisher[] = 0; // مقدار اولیه
        } else {
            $prevFisher = $fisher[$i - 1] ?? 0; // مقدار Fisher قبلی
            $fisher[] = 0.5 * log((1 + $normalized) / (1 - $normalized)) + 0.5 * $prevFisher;
        }
    }

    return $fisher;
}
function calculateMFI($data, $period = 14) {
    if (count($data) < $period) {
        return []; // داده کافی نیست
    }

    $mfi = [];
    $positiveFlow = [];
    $negativeFlow = [];

    for ($i = 1; $i < count($data); $i++) {
        $typicalPrice = ($data[$i][2] + $data[$i][3] + $data[$i][4]) / 3; // (High + Low + Close) / 3
        $moneyFlow = $typicalPrice * $data[$i][5]; // Typical Price * Volume

        $prevTypicalPrice = ($data[$i - 1][2] + $data[$i - 1][3] + $data[$i - 1][4]) / 3;

        if ($typicalPrice > $prevTypicalPrice) {
            $positiveFlow[] = $moneyFlow;
            $negativeFlow[] = 0;
        } elseif ($typicalPrice < $prevTypicalPrice) {
            $positiveFlow[] = 0;
            $negativeFlow[] = $moneyFlow;
        } else {
            $positiveFlow[] = 0;
            $negativeFlow[] = 0;
        }

        if ($i >= $period) {
            $sumPositive = array_sum(array_slice($positiveFlow, -$period));
            $sumNegative = array_sum(array_slice($negativeFlow, -$period));

            if ($sumNegative == 0) {
                $mfi[] = 100;
            } else {
                $moneyRatio = $sumPositive / $sumNegative;
                $mfi[] = 100 - (100 / (1 + $moneyRatio));
            }
        } else {
            $mfi[] = null;
        }
    }

    return $mfi;
}
function calculateOBV($data) {
    if (count($data) < 2) {
        return []; // داده کافی نیست
    }

    $obv = [0]; // مقدار اولیه OBV را صفر می‌گذاریم

    for ($i = 1; $i < count($data); $i++) {
        $currentClose = $data[$i][4];  // قیمت بسته شدن فعلی
        $previousClose = $data[$i - 1][4]; // قیمت بسته شدن قبلی
        $volume = $data[$i][5]; // حجم معاملات

        if ($currentClose > $previousClose) {
            $obv[] = $obv[$i - 1] + $volume;
        } elseif ($currentClose < $previousClose) {
            $obv[] = $obv[$i - 1] - $volume;
        } else {
            $obv[] = $obv[$i - 1];
        }
    }

    return $obv;
}
function calculateGannFan($data, $anchorIndex) {
    if (count($data) < $anchorIndex + 1) {
        return []; // داده کافی نیست
    }

    $anchorPoint = $data[$anchorIndex][4]; // قیمت بسته شدن نقطه شروع
    $gannLevels = [
        '1x8' => [],
        '1x4' => [],
        '1x3' => [],
        '1x2' => [],
        '1x1' => [],
        '2x1' => [],
        '3x1' => [],
        '4x1' => [],
        '8x1' => []
    ];

    for ($i = $anchorIndex, $step = 1; $i < count($data); $i++, $step++) {
        foreach ($gannLevels as $ratio => &$level) {
            $parts = explode('x', $ratio);
            $x = (int)$parts[0];
            $y = (int)$parts[1];

            // محاسبه زاویه قیمت نسبت به زمان
            $level[] = $anchorPoint + ($step * ($y / $x) * 10); // فاکتور 10 برای تنظیم مقیاس
        }
    }

    return $gannLevels;
}
function calculateWilliamsR($data, $period = 14) {
    if (count($data) < $period) {
        return []; // داده کافی نیست
    }

    $williamsR = [];

    for ($i = 0; $i < count($data); $i++) {
        if ($i < $period - 1) {
            $williamsR[] = null;
            continue;
        }

        $slice = array_slice($data, $i - ($period - 1), $period);
        $highestHigh = max(array_column($slice, 2)); // بالاترین قیمت‌ها
        $lowestLow = min(array_column($slice, 3));   // پایین‌ترین قیمت‌ها
        $close = $data[$i][4]; // قیمت بسته شدن

        if ($highestHigh - $lowestLow == 0) {
            $williamsR[] = null;
        } else {
            $williamsR[] = (($highestHigh - $close) / ($highestHigh - $lowestLow)) * -100;
        }
    }

    return $williamsR;
}
function calculateStochastic($data, $period = 14, $smoothK = 3, $smoothD = 3) {
    if (count($data) < $period) {
        return ['k' => [], 'd' => []]; // داده کافی نیست
    }

    $stochastic = ['k' => [], 'd' => []];
    $kValues = [];

    for ($i = 0; $i < count($data); $i++) {
        if ($i < $period - 1) {
            $stochastic['k'][] = null;
            $stochastic['d'][] = null;
            continue;
        }

        $slice = array_slice($data, $i - ($period - 1), $period);
        $highs = array_column($slice, 2); // بالاترین قیمت‌ها
        $lows = array_column($slice, 3);  // پایین‌ترین قیمت‌ها
        $close = $data[$i][4]; // قیمت بسته شدن

        $highestHigh = max($highs);
        $lowestLow = min($lows);
        $k = (($close - $lowestLow) / ($highestHigh - $lowestLow)) * 100;

        $kValues[] = $k;
        if (count($kValues) > $smoothK) {
            array_shift($kValues);
        }

        $stochastic['k'][] = array_sum($kValues) / count($kValues);

        if ($i >= $period - 1 + $smoothD - 1) {
            $sliceD = array_slice($stochastic['k'], -$smoothD);
            $stochastic['d'][] = array_sum($sliceD) / count($sliceD);
        } else {
            $stochastic['d'][] = null;
        }
    }

    return $stochastic;
}
function calculatePPO($data, $shortPeriod = 12, $longPeriod = 26, $signalPeriod = 9) {
    if (count($data) < $longPeriod) {
        return ['ppo' => [], 'signal' => [], 'histogram' => []]; // داده کافی نیست
    }

    $closePrices = array_column($data, 4); // قیمت بسته شدن
    $emaShort = calculateEMA($closePrices, $shortPeriod);
    $emaLong = calculateEMA($closePrices, $longPeriod);
    
    $ppo = [];
    $ppoSignal = [];
    $ppoHistogram = [];

    for ($i = 0; $i < count($emaShort); $i++) {
        if ($emaLong[$i] == 0) {
            $ppo[] = null;
        } else {
            $ppo[] = (($emaShort[$i] - $emaLong[$i]) / $emaLong[$i]) * 100;
        }
    }

    $ppoSignal = calculateEMA($ppo, $signalPeriod);

    for ($i = 0; $i < count($ppo); $i++) {
        if ($ppo[$i] !== null && $ppoSignal[$i] !== null) {
            $ppoHistogram[] = $ppo[$i] - $ppoSignal[$i];
        } else {
            $ppoHistogram[] = null;
        }
    }

    return ['ppo' => $ppo, 'signal' => $ppoSignal, 'histogram' => $ppoHistogram];
}
function calculateFibonacciRetracement($data) {
    if (count($data) < 2) {
        return []; // حداقل دو کندل نیاز است
    }

    $high = max(array_column($data, 2));  // بیشترین قیمت در بازه
    $low = min(array_column($data, 3));   // کمترین قیمت در بازه
    $difference = $high - $low;

    return [
        '100%' => $high,
        '78.6%' => $high - ($difference * 0.786),
        '61.8%' => $high - ($difference * 0.618),
        '50%' => $high - ($difference * 0.50),
        '38.2%' => $high - ($difference * 0.382),
        '23.6%' => $high - ($difference * 0.236),
        '0%' => $low
    ];
}
function calculateEMA($prices, $period) {
    $ema = [];
    $multiplier = 2 / ($period + 1);
    
    foreach ($prices as $i => $price) {
        if ($i == 0) {
            $ema[] = $price;
        } else {
            $ema[] = ($price - $ema[$i - 1]) * $multiplier + $ema[$i - 1];
        }
    }
    
    return $ema;
}
function calculatePivotPoints($data) {
    if (count($data) < 2) {
        return []; // حداقل دو کندل نیاز است
    }

    $yesterday = $data[count($data) - 2]; // روز قبل
    $high = $yesterday[2];  // بالاترین قیمت
    $low = $yesterday[3];   // پایین‌ترین قیمت
    $close = $yesterday[4]; // قیمت بسته شدن

    // محاسبه نقاط پیوت و سطوح حمایت و مقاومت
    $pivot = ($high + $low + $close) / 3;
    $resistance1 = (2 * $pivot) - $low;
    $resistance2 = $pivot + ($high - $low);
    $resistance3 = $high + 2 * ($pivot - $low);
    $support1 = (2 * $pivot) - $high;
    $support2 = $pivot - ($high - $low);
    $support3 = $low - 2 * ($high - $pivot);

    return [
        'pivot' => $pivot,
        'resistance1' => $resistance1,
        'resistance2' => $resistance2,
        'resistance3' => $resistance3,
        'support1' => $support1,
        'support2' => $support2,
        'support3' => $support3
    ];
}
function calculateROC($data, $period = 14) {
    if (count($data) < $period) {
        return []; // داده کافی نیست
    }

    $roc = [];

    for ($i = 0; $i < count($data); $i++) {
        if ($i < $period) {
            $roc[] = null;
            continue;
        }

        $previousClose = $data[$i - $period][4]; // قیمت بسته شدن دوره قبلی
        $currentClose = $data[$i][4]; // قیمت بسته شدن فعلی

        $roc[] = ($previousClose > 0) ? (($currentClose - $previousClose) / $previousClose) * 100 : 0;
    }

    return $roc;
}
function calculateKeltnerChannel($data, $emaPeriod = 20, $atrPeriod = 10, $atrMultiplier = 2) {
    $keltner = [];
    $emaValues = [];
    $atrValues = calculateATR($data, $atrPeriod);

    // محاسبه EMA
    foreach ($data as $index => $candle) {
        $close = $candle[4];
        if ($index == 0) {
            $emaValues[$index] = $close;
        } else {
            $emaValues[$index] = ($close * (2 / ($emaPeriod + 1))) + ($emaValues[$index-1] * (1 - (2 / ($emaPeriod + 1))));
        }
    }

    // محاسبه کانال کلتنر
    foreach ($emaValues as $index => $ema) {
        if (isset($atrValues[$index])) {
            $keltner[$index] = [
                'upper' => $ema + ($atrValues[$index] * $atrMultiplier),
                'middle' => $ema,
                'lower' => $ema - ($atrValues[$index] * $atrMultiplier)
            ];
        }
    }

    return $keltner;
}
function calculateCCI($data, $period = 20) {
    if (count($data) < $period) {
        return []; // اگر داده‌ها کافی نباشد، مقدار خالی برگردانده شود
    }

    $cci = [];
    $typicalPrices = [];

    foreach ($data as $index => $candle) {
        $typicalPrice = ($candle[2] + $candle[3] + $candle[4]) / 3; // (High + Low + Close) / 3
        $typicalPrices[] = $typicalPrice;

        if ($index >= $period - 1) {
            $slice = array_slice($typicalPrices, -$period);
            $sma = array_sum($slice) / $period;
            $meanDeviation = array_sum(array_map(fn($x) => abs($x - $sma), $slice)) / $period;
            
            $cci[$index] = ($typicalPrice - $sma) / (0.015 * $meanDeviation);
        } else {
            $cci[$index] = null; // مقدار کافی برای محاسبه CCI وجود ندارد
        }
    }

    return $cci;
}
function calculateDonchianChannels($data, $period = 20) {
    if (count($data) < $period) {
        return ['upper' => [], 'middle' => [], 'lower' => []]; // داده کافی نیست
    }

    $donchianChannels = ['upper' => [], 'middle' => [], 'lower' => []];

    for ($i = 0; $i < count($data); $i++) {
        if ($i < $period - 1) {
            $donchianChannels['upper'][] = null;
            $donchianChannels['middle'][] = null;
            $donchianChannels['lower'][] = null;
            continue;
        }

        $slice = array_slice($data, $i - ($period - 1), $period);
        $highs = array_column($slice, 2); // بالاترین قیمت‌ها
        $lows = array_column($slice, 3);  // پایین‌ترین قیمت‌ها

        $upper = max($highs);
        $lower = min($lows);
        $middle = ($upper + $lower) / 2;

        $donchianChannels['upper'][] = $upper;
        $donchianChannels['middle'][] = $middle;
        $donchianChannels['lower'][] = $lower;
    }

    return $donchianChannels;
}
function calculateParabolicSAR($data, $afStart = 0.02, $afIncrement = 0.02, $afMax = 0.20) {
    $sar = [];
    $trend = null; // روند: 1 = صعودی، -1 = نزولی
    $ep = 0; // Extreme Point
    $af = $afStart; // Acceleration Factor
    
    // مقداردهی اولیه
    $sar[0] = null; // SAR اولیه تعریف نشده
    $sar[1] = $data[1][3]; // SAR دوم برابر با پایین‌ترین قیمت اول
    
    // تعیین روند اولیه
    if ($data[1][2] > $data[0][2]) { // بالاترین قیمت افزایش یافته
        $trend = 1;
        $ep = $data[1][2]; // بالاترین قیمت
    } else {
        $trend = -1;
        $ep = $data[1][3]; // پایین‌ترین قیمت
    }
    
    // محاسبه SAR برای داده‌های بعدی
    for ($i = 2; $i < count($data); $i++) {
        $high = $data[$i][2];
        $low = $data[$i][3];
        $prevSar = $sar[$i-1];
        
        if ($trend == 1) {
            // روند صعودی
            $sar[$i] = $prevSar + $af * ($ep - $prevSar);
            
            // بررسی شکست SAR
            if ($low <= $sar[$i]) {
                $trend = -1;
                $sar[$i] = $ep;
                $ep = $low;
                $af = $afStart;
            } else {
                if ($high > $ep) {
                    $ep = $high;
                    $af = min($af + $afIncrement, $afMax);
                }
            }
        } else {
            // روند نزولی
            $sar[$i] = $prevSar - $af * ($prevSar - $ep);
            
            // بررسی شکست SAR
            if ($high >= $sar[$i]) {
                $trend = 1;
                $sar[$i] = $ep;
                $ep = $high;
                $af = $afStart;
            } else {
                if ($low < $ep) {
                    $ep = $low;
                    $af = min($af + $afIncrement, $afMax);
                }
            }
        }
    }
    
    return $sar;
}
function calculateIchimoku($data, $tenkanPeriod = 9, $kijunPeriod = 26, $senkouSpanBPeriod = 52) {
    $ichimoku = [];
    
    foreach ($data as $index => $candle) {
        $high = $candle[2]; // بالاترین قیمت
        $low = $candle[3];  // پایین‌ترین قیمت
        $close = $candle[4]; // قیمت بسته شدن
        
        // تنکان سن (Tenkan-sen)
        if ($index >= $tenkanPeriod - 1) {
            $slice = array_slice($data, $index - ($tenkanPeriod - 1), $tenkanPeriod);
            $highs = array_column($slice, 2);
            $lows = array_column($slice, 3);
            $ichimoku[$index]['tenkan_sen'] = (max($highs) + min($lows)) / 2;
        }
        
        // کیجون سن (Kijun-sen)
        if ($index >= $kijunPeriod - 1) {
            $slice = array_slice($data, $index - ($kijunPeriod - 1), $kijunPeriod);
            $highs = array_column($slice, 2);
            $lows = array_column($slice, 3);
            $ichimoku[$index]['kijun_sen'] = (max($highs) + min($lows)) / 2;
        }
        
        // سنکو اسپن A (Senkou Span A)
        if ($index >= $kijunPeriod - 1) {
            $ichimoku[$index]['senkou_span_a'] = ($ichimoku[$index]['tenkan_sen'] + $ichimoku[$index]['kijun_sen']) / 2;
        }
        
        // سنکو اسپن B (Senkou Span B)
        if ($index >= $senkouSpanBPeriod - 1) {
            $slice = array_slice($data, $index - ($senkouSpanBPeriod - 1), $senkouSpanBPeriod);
            $highs = array_column($slice, 2);
            $lows = array_column($slice, 3);
            $ichimoku[$index]['senkou_span_b'] = (max($highs) + min($lows)) / 2;
        }
        
        // چیکو اسپن (Chikou Span)
        if ($index >= $kijunPeriod - 1) {
            $ichimoku[$index]['chikou_span'] = $data[$index - ($kijunPeriod - 1)][4];
        }
    }
    
    return $ichimoku;
}

function getCryptoPrices($cryptoList) {
    $prices = [];
    foreach ($cryptoList as $name => $symbol) {
        $url = "https://api.binance.com/api/v3/ticker/24hr?symbol=$symbol";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $data = json_decode($response, true);
        if ($data && !isset($data['code'])) {
            $prices[$name] = [
                "price" => round($data['lastPrice'], 2),
                "change" => round($data['priceChangePercent'], 2)
            ];
        }
    }
    return $prices;
}
function calculateATR($data, $period = 14) {
    $atr = [];
    $trueRanges = [];
    
    for ($i = 1; $i < count($data); $i++) {
        $high = $data[$i][2]; // بالاترین قیمت
        $low = $data[$i][3];  // پایین‌ترین قیمت
        $prevClose = $data[$i-1][4]; // قیمت بسته شدن قبلی
        
        // محاسبه محدوده واقعی (True Range)
        $trueRange = max(
            $high - $low,
            abs($high - $prevClose),
            abs($low - $prevClose)
        );
        $trueRanges[] = $trueRange;
        
        // محاسبه ATR
        if ($i >= $period) {
            if ($i == $period) {
                $atr[$i] = array_sum(array_slice($trueRanges, 0, $period)) / $period;
            } else {
                $atr[$i] = (($atr[$i-1] * ($period - 1)) + $trueRange) / $period;
            }
        }
    }
    
    return $atr;
}
function getBinanceOrderFlowData($symbol, $interval = "1m", $limit = 100) {
    $url = "https://api.binance.com/api/v3/klines?symbol=$symbol&interval=$interval&limit=$limit";

    $json = file_get_contents($url);
    if (!$json) {
        return null;
    }

    $data = json_decode($json, true);
    if (!$data || !is_array($data)) {
        return null;
    }

    $orderFlowData = [];
    foreach ($data as $candle) {
        $orderFlowData[] = [
            'timestamp' => $candle[0],    // زمان باز شدن کندل
            'open' => (float)$candle[1],  // قیمت باز شدن
            'high' => (float)$candle[2],  // بالاترین قیمت
            'low' => (float)$candle[3],   // پایین‌ترین قیمت
            'close' => (float)$candle[4], // قیمت بسته شدن
            'volume' => (float)$candle[5], // حجم کل معاملات
            'buy_volume' => (float)$candle[9],  // حجم خرید بازار
            'sell_volume' => (float)$candle[5] - (float)$candle[9] // حجم فروش بازار
        ];
    }

    return $orderFlowData;
}
function calculateADX($data, $period = 14) {
    $adx = [];
    $plusDM = []; // +DM
    $minusDM = []; // -DM
    $plusDI = []; // +DI
    $minusDI = []; // -DI
    $trueRanges = [];
    
    for ($i = 1; $i < count($data); $i++) {
        $high = $data[$i][2]; // بالاترین قیمت
        $low = $data[$i][3];  // پایین‌ترین قیمت
        $prevHigh = $data[$i-1][2]; // بالاترین قیمت قبلی
        $prevLow = $data[$i-1][3];  // پایین‌ترین قیمت قبلی
        
        // محاسبه +DM و -DM
        $plusDM[$i] = max(0, $high - $prevHigh);
        $minusDM[$i] = max(0, $prevLow - $low);
        
        // محاسبه True Range
        $trueRange = max(
            $high - $low,
            abs($high - $prevClose),
            abs($low - $prevClose)
        );
        $trueRanges[] = $trueRange;
        
        // محاسبه +DI و -DI
        if ($i >= $period) {
            $plusDI[$i] = 100 * (array_sum(array_slice($plusDM, $i - $period, $period)) / array_sum(array_slice($trueRanges, $i - $period, $period)));
            $minusDI[$i] = 100 * (array_sum(array_slice($minusDM, $i - $period, $period)) / array_sum(array_slice($trueRanges, $i - $period, $period)));
            
            // محاسبه ADX
            $dx = 100 * abs($plusDI[$i] - $minusDI[$i]) / ($plusDI[$i] + $minusDI[$i]);
            if ($i == $period) {
                $adx[$i] = $dx;
            } else {
                $adx[$i] = (($adx[$i-1] * ($period - 1)) + $dx) / $period;
            }
        }
    }
    
    return [
        'adx' => $adx,
        'plus_di' => $plusDI,
        'minus_di' => $minusDI
    ];
}
function calculateMACD($data, $fastPeriod = 12, $slowPeriod = 26, $signalPeriod = 9) {
    $emaFast = []; // EMA سریع
    $emaSlow = []; // EMA کند
    $macdLine = []; // خط MACD
    $signalLine = []; // خط سیگنال
    $histogram = []; // هیستوگرام
    
    foreach ($data as $index => $candle) {
        $price = $candle[4]; // قیمت بسته شدن
        
        // محاسبه EMA سریع (12 دوره)
        if ($index == 0) {
            $emaFast[$index] = $price; // اولین EMA برابر با قیمت فعلی
        } else {
            $emaFast[$index] = ($price * (2 / ($fastPeriod + 1))) + ($emaFast[$index-1] * (1 - (2 / ($fastPeriod + 1))));
        }
        
        // محاسبه EMA کند (26 دوره)
        if ($index == 0) {
            $emaSlow[$index] = $price; // اولین EMA برابر با قیمت فعلی
        } else {
            $emaSlow[$index] = ($price * (2 / ($slowPeriod + 1))) + ($emaSlow[$index-1] * (1 - (2 / ($slowPeriod + 1))));
        }
        
        // محاسبه خط MACD (تفاوت EMA سریع و کند)
        $macdLine[$index] = $emaFast[$index] - $emaSlow[$index];
    }
    
    // محاسبه خط سیگنال (EMA 9 دوره‌ای از خط MACD)
    foreach ($macdLine as $index => $value) {
        if ($index == 0) {
            $signalLine[$index] = $value; // اولین سیگنال برابر با MACD فعلی
        } else {
            $signalLine[$index] = ($value * (2 / ($signalPeriod + 1))) + ($signalLine[$index-1] * (1 - (2 / ($signalPeriod + 1))));
        }
        
        // محاسبه هیستوگرام (تفاوت MACD و Signal)
        $histogram[$index] = $macdLine[$index] - $signalLine[$index];
    }
    
    return [
        'macd' => $macdLine,
        'signal' => $signalLine,
        'histogram' => $histogram
    ];
}
function calculateStandardDeviation($array) {
    $count = count($array);
    if ($count < 2) return 0; // حداقل ۲ داده نیاز است
    
    $mean = array_sum($array) / $count;
    $variance = 0.0;
    
    foreach ($array as $value) {
        $variance += pow($value - $mean, 2);
    }
    
    return sqrt($variance / $count);
}
function calculateBollingerBands($data, $period = 20, $deviation = 2) {
    $bands = [];
    
    foreach ($data as $index => $candle) {
        if ($index < $period) continue; // حداقل داده برای محاسبه
        
        $slice = array_slice($data, $index - $period, $period);
        $closes = array_column($slice, 4); // قیمت‌های بسته شدن
        $sma = array_sum($closes) / $period; // میانگین متحرک ساده
        $stdDev = calculateStandardDeviation($closes); // انحراف معیار
        
        $bands[$index] = [
            'upper' => $sma + ($stdDev * $deviation),
            'middle' => $sma,
            'lower' => $sma - ($stdDev * $deviation)
        ];
    }
    
    return $bands;
}
function getLatestIdeas() {
    $feed_url = 'https://www.coindesk.com/feed/'; // جایگزینی با فید جدید
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $feed_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // غیرفعال کردن بررسی SSL
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        return "❌ خطا در اتصال به سرور: " . curl_error($ch);
    }
    curl_close($ch);

    // بررسی محتوای فید
    if (empty($response)) {
        return "❌ فید RSS خالی است!";
    }

    // پردازش XML
    libxml_use_internal_errors(true); // فعال کردن مدیریت خطاهای XML
    $xml = simplexml_load_string($response);
    if (!$xml) {
        $errors = libxml_get_errors();
        $errorMessages = [];
        foreach ($errors as $error) {
            $errorMessages[] = "خطا در خط {$error->line}: {$error->message}";
        }
        return "❌ خطا در تجزیه فید RSS:\n" . implode("\n", $errorMessages);
    }

    // استخراج ایده‌ها
    $ideas = "💡 *آخرین اخبار و ایده‌ها:* \n\n";
    $max_items = 5;
    $items = $xml->xpath('//item');
    if (empty($items)) {
        return "❌ هیچ خبری در فید یافت نشد!";
    }

    $items = array_slice($items, 0, $max_items);
    foreach ($items as $item) {
        $title = (string)$item->title;
        $link = (string)$item->link;
        $date = date("Y-m-d H:i", strtotime((string)$item->pubDate));
        $ideas .= "🔹 [$title]($link)\n🗓️ $date\n\n";
    }

    return $ideas;
}
function getMarketDataFromBinance() {
    $url = "https://api.binance.com/api/v3/ticker/24hr";
    $response = file_get_contents($url);
    if (!$response) return false;

    $data = json_decode($response, true);
    if (!is_array($data)) return false;

    $totalVolume = 0;
    $btcVolume = 0;

    foreach ($data as $ticker) {
        $totalVolume += $ticker['quoteVolume']; // حجم معاملات کل بازار
        if ($ticker['symbol'] === "BTCUSDT") {
            $btcVolume = $ticker['quoteVolume']; // حجم معاملات بیت‌کوین
        }
    }

    $btcDominance = ($btcVolume / $totalVolume) * 100; // محاسبه دامیننس BTC

    return [
        'total_volume' => number_format($totalVolume, 2),
        'btc_dominance' => round($btcDominance, 2),
        'last_updated' => date("Y-m-d H:i:s") // زمان بروزرسانی
    ];
}
function calculateRSI($data, $period = 14) {
    $limitedData = array_slice($data, -$limit);
    $changes = [];
    $rsi = [];
    
    for ($i = 1; $i < count($limitedData); $i++) {
        $changes[] = $limitedData[$i][4] - $limitedData[$i-1][4];
    }
    
    for ($i = 0; $i < count($changes); $i++) {
        $avgGain = $avgLoss = 0;
        
        if ($i < $period) continue;
        
        $slice = array_slice($changes, $i-$period, $period);
        $avgGain = array_sum(array_filter($slice, function($v) { return $v > 0; }));
        $avgLoss = abs(array_sum(array_filter($slice, function($v) { return $v < 0; })));
        
        $rs = ($avgLoss == 0) ? INF : $avgGain / $avgLoss;
        $rsi[] = 100 - (100 / (1 + $rs));
    }
    
    return $rsi;
}
function showPercentageMenu($chatid, $messageid, $currentPrice, $direction) {
    $percentages = [1, 2, 3, 5, 7, 10, 15, 20, 25, 50];
    
    $keyboard = [];
    $row = [];
    
    foreach ($percentages as $percent) {
        // محاسبه قیمت هدف
        $targetPrice = $direction == "بالا" 
            ? $currentPrice * (1 + ($percent/100))
            : $currentPrice * (1 - ($percent/100));
        
        $buttonText = "$percent% (".number_format($targetPrice, 2).")";
        
        $row[] = [
            'text' => $buttonText,
            'callback_data' => "select_percent:$percent"
        ];
        
        if(count($row) == 2) {
            $keyboard[] = $row;
            $row = [];
        }
    }
    
    // افزودن گزینه دستی
    $keyboard[] = [['text' => "🔢 وارد کردن دستی", 'callback_data' => "custom_price"]];
    $keyboard[] = [['text' => "❌ لغو", 'callback_data' => "cancel_alert"]];
    
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 *قیمت فعلی:* ".number_format($currentPrice, 2)."\n".
                  "📌 درصد تغییر مورد نظر را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}
function getCurrentPrice($symbol) {
    $url = "https://api.binance.com/api/v3/ticker/price?symbol=" . urlencode($symbol);
    $response = json_decode(file_get_contents($url), true);
    return isset($response['price']) ? (float)$response['price'] : false;
}
function showSymbolsPage($chatid, $messageid, $page) {
    global $popularSymbols;
    $perPage = 5; // تعداد ارزها در هر صفحه
    $totalPages = ceil(count($popularSymbols) / $perPage);
    $start = $page * $perPage;
    $currentSymbols = array_slice($popularSymbols, $start, $perPage);

    // ساخت کیبورد
    $keyboard = [];
    foreach ($currentSymbols as $symbol) {
        $keyboard[] = [['text' => $symbol, 'callback_data' => "select_symbol:$symbol"]];
    }

    // دکمه‌های صفحه‌بندی
    $pagination = [];
    if ($page > 0) {
        $pagination[] = ['text' => "⬅️ صفحه قبل", 'callback_data' => "symbol_page:" . ($page - 1)];
    }
    if ($page < $totalPages - 1) {
        $pagination[] = ['text' => "صفحه بعد ➡️", 'callback_data' => "symbol_page:" . ($page + 1)];
    }
    if (!empty($pagination)) {
        $keyboard[] = $pagination;
    }

    $keyboard[] = [['text' => "❌ لغو", 'callback_data' => "cancel_alert"]];

    // ارسال پیام
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "🔍 لطفا نماد ارز را انتخاب کنید: (صفحه " . ($page + 1) . "/$totalPages)",
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}
function calculateMovingMedian($data, $period = 20) {
    if (count($data) < $period) {
        return []; // داده کافی نیست
    }

    $movingMedian = [];

    for ($i = 0; $i < count($data); $i++) {
        if ($i < $period - 1) {
            $movingMedian[] = null;
            continue;
        }

        $slice = array_slice($data, $i - ($period - 1), $period);
        $closePrices = array_column($slice, 4); // قیمت بسته شدن
        sort($closePrices);
        $midIndex = floor(count($closePrices) / 2);

        if (count($closePrices) % 2 == 0) {
            $median = ($closePrices[$midIndex - 1] + $closePrices[$midIndex]) / 2;
        } else {
            $median = $closePrices[$midIndex];
        }

        $movingMedian[] = $median;
    }

    return $movingMedian;
}
function fetchCNYRateFromJson($chatid = '@sna_cny') {
    try {
        // URL API
        $apiUrl = 'http://api.navasan.tech/latest/?api_key=freeBVGfVYU2R6jzdXVDLk4CHob7ErHH';
        
        // دانلود فایل JSON
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        $jsonData = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // چک کردن خطا در دانلود
        if ($httpCode !== 200) {
            throw new Exception("خطا در دانلود فایل (کد: $httpCode)");
        }

        // ذخیره فایل JSON روی سرور
        $filePath = 'currency_data.json';
        if (!file_put_contents($filePath, $jsonData)) {
            throw new Exception("خطا در ذخیره فایل JSON!");
        }

        // خواندن داده‌ها از فایل
        $result = json_decode(file_get_contents($filePath), true);
        if (!$result || !is_array($result)) {
            throw new Exception("داده‌ها توی فایل درست نیست!");
        }

        // استخراج داده برای cny (مستقیم از ریشه JSON)
        $cnyData = isset($result['cny']) ? $result['cny'] : null;
        if ($cnyData === null) {
            throw new Exception("داده برای cny پیدا نشد!");
        }

        // گرفتن فیلدها از cnyData
        $value = number_format($cnyData['value'], 0, '.', ','); // برای خوانایی
        $change = $cnyData['change'];
        $date = $cnyData['date'];
        $changeSign = $change >= 0 ? '+' : '';

        // ساخت پیام
        $message = "💱 *نرخ یوان چین (cny) به ریال (". date('Y-m-d H:i') .")*\n\n";
        $message .= "🔹 یوان چین (cny):\n";
        $message .= "   ➡️ نرخ: $value ریال\n";
        $message .= "   ➡️ تغییر: $changeSign$change ریال\n";
        $message .= "   ➡️ تاریخ: $date\n\n";
        $message .= "📢 *از ما بخرید، بدون کارمزد!*\n";
        $message .= "👉 برای خرید ارز با بهترین نرخ، به ما پیام بدید: @signalica";

        // ارسال پیام به چت یا چنل
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => $message,
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "بازگشت ↩️", 'callback_data' => "back_to_menu"]]
                ]
            ])
        ]);

    } catch (Exception $e) {
        // ارسال پیام خطا
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ خطا: " . $e->getMessage()
        ]);
        error_log("CNY Rate Error: " . $e->getMessage(), 3, "data/errors.log");
    }
}
function fetchTopCurrenciesFromJson($chatid) {
    try {
        // URL API
        $apiUrl = 'https://v6.exchangerate-api.com/v6/5ff2c8a5718ed0948e76651a/latest/USD';
        
        // دانلود داده‌ها
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        $jsonData = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // چک کردن خطا
        if ($httpCode !== 200) {
            throw new Exception("خطا در دریافت داده‌ها (کد: $httpCode)");
        }

        // ذخیره فایل JSON
        $filePath = 'usd_data.json';
        if (!file_put_contents($filePath, $jsonData)) {
            throw new Exception("خطا در ذخیره فایل JSON!");
        }

        // خواندن داده‌ها
        $result = json_decode(file_get_contents($filePath), true);
        if (!$result || !is_array($result) || $result['result'] !== 'success') {
            throw new Exception("داده‌ها درست نیست!");
        }

        // لیست ۱۰ ارز برتر
        $currencies = [
            'EUR' => 'یورو',
            'GBP' => 'پوند انگلیس',
            'JPY' => 'ین ژاپن',
            'CNY' => 'یوان چین',
            'CAD' => 'دلار کانادا',
            'AUD' => 'دلار استرالیا',
            'CHF' => 'فرانک سوئیس',
            'HKD' => 'دلار هنگ‌کنگ',
            'SGD' => 'دلار سنگاپور',
            'KRW' => 'وون کره جنوبی'
        ];

        // ساخت پیام
        $message = "💱 *نرخ ارزها به دلار آمریکا (". date('Y-m-d H:i') .")*\n\n";
        $found = false;

        foreach ($currencies as $code => $name) {
            $rate = isset($result['conversion_rates'][$code]) ? $result['conversion_rates'][$code] : null;
            if ($rate === null) {
                continue;
            }

            $found = true;
            $formattedRate = number_format($rate, 4, '.', ',');
            $message .= "🔹 $name ($code):\n";
            $message .= "   ➡️ نرخ: $formattedRate دلار\n\n";
        }

        if (!$found) {
            throw new Exception("هیچ داده‌ای برای ارزها پیدا نشد!");
        }

        // اضافه کردن پیام تبلیغاتی
        $message .= "📢 *از ما بخرید، بدون کارمزد!*\n";
        $message .= "👉 برای خرید ارز با بهترین نرخ، به ما پیام بدید: @signalica";

        // ارسال پیام به کاربر
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => $message,
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "بازگشت ↩️", 'callback_data' => "back_to_menu"]]
                ]
            ])
        ]);

    } catch (Exception $e) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ خطا: " . $e->getMessage()
        ]);
        error_log("Currency Rate Error: " . $e->getMessage(), 3, "data/errors.log");
    }
}
function checkPriceAlerts() {
    // بررسی وجود فایل هشدارها
    if (!file_exists("alerts.txt")) {
        return;
    }

    // باز کردن فایل با قفل نوشتن
    $file = fopen("alerts.txt", "r+");
    if (!flock($file, LOCK_EX)) {
        fclose($file);
        return;
    }

    // خواندن تمام هشدارها
    $alerts = [];
    while (!feof($file)) {
        $line = trim(fgets($file));
        if (!empty($line)) {
            $alerts[] = $line;
        }
    }

    // آماده‌سازی درخواست‌های همزمان
    $multiHandle = curl_multi_init();
    $handles = [];

    // ایجاد درخواست برای هر هشدار
    foreach ($alerts as $index => $alert) {
        list($chatid, $symbol, $direction, $target) = explode("|", $alert);
        $url = "https://api.binance.com/api/v3/ticker/price?symbol=" . urlencode($symbol);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_SSL_VERIFYPEER => false
        ]);

        $handles[$index] = ['handle' => $ch, 'alert' => $alert];
        curl_multi_add_handle($multiHandle, $ch);
    }

    // اجرای همزمان درخواست‌ها
    do {
        curl_multi_exec($multiHandle, $running);
        curl_multi_select($multiHandle);
    } while ($running > 0);

    // پاکسازی فایل هشدارها
    ftruncate($file, 0);
    fseek($file, 0);

    // پردازش پاسخ‌ها
    foreach ($handles as $data) {
        $ch = $data['handle'];
        $alert = $data['alert'];

        list($chatid, $symbol, $direction, $target) = explode("|", $alert);
        $response = json_decode(curl_multi_getcontent($ch), true);

        if (isset($response['price'])) {
            $current = (float)$response['price'];
            $target = (float)$target;

            // بررسی فعال شدن هشدار
            $triggered = false;
            if ($direction == "بالا" && $current >= $target) {
                $triggered = true;
            } elseif ($direction == "پایین" && $current <= $target) {
                $triggered = true;
            }

            if (!$triggered) {
                // ذخیره مجدد هشدارهای غیرفعال
                fwrite($file, $alert . PHP_EOL);
            } else {
                // محاسبه درصد تغییرات
                $percentageChange = ($target != 0) 
                    ? abs((($current / $target) - 1) * 100)
                    : 0.0;

                // فرمت‌دهی اعداد
                $formattedCurrent = number_format($current, 2, '.', ',');
                $formattedChange = number_format($percentageChange, 2, '.', ',');

                // ارسال پیام هشدار
                bot('sendMessage', [
                    'chat_id' => $chatid,
                    'text' => 
                        "🚨 *هشدار فعال شد!*\n\n" .
                        "▫️ نماد: `" . strtoupper($symbol) . "`\n" .
                        "▫️ قیمت فعلی: `$formattedCurrent`\n" .
                        "▫️ تغییرات: $formattedChange%",
                    'parse_mode' => "Markdown",
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [[
                            'text' => "🗑 حذف هشدار",
                            'callback_data' => "delete_alert:$symbol"
                        ]]
                    ])
                ]);
            }
        } else {
            // ذخیره مجدد در صورت خطا
            fwrite($file, $alert . PHP_EOL);
        }

        // پاکسازی منابع
        curl_multi_remove_handle($multiHandle, $ch);
        curl_close($ch);
    }

    // آزادسازی قفل و بستن فایل
    flock($file, LOCK_UN);
    fclose($file);
    curl_multi_close($multiHandle);
}
function getTopFundamentalProjectsBinance() {
    $url = "https://api.binance.com/api/v3/ticker/24hr";
    $response = file_get_contents($url);
    if (!$response) return false;

    $data = json_decode($response, true);
    if (!is_array($data)) return false;

    usort($data, function ($a, $b) {
        return $b['quoteVolume'] <=> $a['quoteVolume']; // مرتب‌سازی بر اساس حجم معاملات
    });

    $topProjects = array_slice($data, 0, 5); // دریافت ۵ پروژه برتر

    $projects = [];
    foreach ($topProjects as $coin) {
        $projects[] = [
            'symbol' => strtoupper($coin['symbol']),
            'price' => number_format($coin['lastPrice'], 2),
            'volume' => number_format($coin['quoteVolume']),
            'change' => round($coin['priceChangePercent'], 2)
        ];
    }

    return $projects;
}
function getFearGreedIndex() {
    $url = "https://api.alternative.me/fng/?limit=10";
    $response = file_get_contents($url);
    if (!$response) return false;

    $data = json_decode($response, true);
    if (!isset($data['data']) || count($data['data']) < 7) return false;

    return [
        'today' => [
            'value' => $data['data'][0]['value'],
            'text' => $data['data'][0]['value_classification'],
            'date' => date("Y-m-d", $data['data'][0]['timestamp'])
        ],
        'yesterday' => [
            'value' => $data['data'][1]['value'] ?? 'N/A',
            'text' => $data['data'][1]['value_classification'] ?? 'N/A',
            'date' => isset($data['data'][1]['timestamp']) ? date("Y-m-d", $data['data'][1]['timestamp']) : 'N/A'
        ],
        'last_week' => [
            'value' => $data['data'][6]['value'] ?? 'N/A',
            'text' => $data['data'][6]['value_classification'] ?? 'N/A',
            'date' => isset($data['data'][6]['timestamp']) ? date("Y-m-d", $data['data'][6]['timestamp']) : 'N/A'
        ]
    ];
}
// تابع برای ایجاد نمودار
function createFearGreedChart($data) {
    $width = 800;
    $height = 400;
    $margin = 50;

    $image = imagecreatetruecolor($width, $height);
    $backgroundColor = imagecolorallocate($image, 255, 255, 255);
    $lineColor = imagecolorallocate($image, 0, 0, 255);
    $textColor = imagecolorallocate($image, 0, 0, 0);
    $gridColor = imagecolorallocate($image, 200, 200, 200);
    $watermarkColor = imagecolorallocate($image, 150, 150, 150);

    // فعال کردن آنتی-الیاسینگ برای تصویر
    imageantialias($image, true);

    imagefilledrectangle($image, 0, 0, $width, $height, $backgroundColor);

    // رسم خطوط راهنما
    for ($i = 0; $i <= 100; $i += 25) {
        $y = $height - $margin - ($i * ($height - 2 * $margin) / 100);
        imageline($image, $margin, $y, $width - $margin, $y, $gridColor);
        imagestring($image, 3, 5, $y - 7, $i, $textColor);
    }

    // رسم نمودار با نقاط و خطوط صاف‌تر
    $count = count($data);
    $step = ($width - 2 * $margin) / ($count - 1);
    
    for ($i = 0; $i < $count - 1; $i++) {
        $x1 = $margin + $i * $step;
        $y1 = $height - $margin - ($data[$i]['value'] * ($height - 2 * $margin) / 100);
        $x2 = $margin + ($i + 1) * $step;
        $y2 = $height - $margin - ($data[$i + 1]['value'] * ($height - 2 * $margin) / 100);

        // خطوط با Anti-Aliasing
        imageline($image, $x1, $y1, $x2, $y2, $lineColor);
        imagefilledellipse($image, $x1, $y1, 6, 6, $lineColor);
    }

    // برچسب‌های تاریخی
    for ($i = 0; $i < $count; $i++) {
        $x = $margin + $i * $step;
        imagestring($image, 2, $x - 10, $height - $margin + 5, date("m/d", $data[$i]['timestamp']), $textColor);
    }

    // اضافه کردن واترمارک
    imagestring($image, 5, $width - 200, $height - 30, "@SIGNALICA", $watermarkColor);

    // ذخیره تصویر
    $filename = "fear_greed_chart.png";
    imagepng($image, $filename);
    imagedestroy($image);

    return $filename;
}
function bot($method,$datas=[]){
$url = "https://api.telegram.org/bot".API_KEY."/".$method;
$ch = curl_init();
curl_setopt($ch,CURLOPT_URL,$url);
curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
curl_setopt($ch,CURLOPT_POSTFIELDS,$datas);
 $res = curl_exec($ch);
 if(curl_error($ch)){
var_dump(curl_error($ch));
}else{
return json_decode($res);
}
}
function SendMessage($chat_id, $text){
bot('sendMessage',[
'chat_id'=>$chat_id,
'text'=>$text,
'parse_mode'=>'MarkDown'
]);
}
function createKeyboard($string, $rows = 2, $orderBy = '|'){
$array = explode($orderBy, $string);
$arrays = array_chunk($array, $rows);
$keyboards = [];
foreach($arrays as $array){
$keyboard = [];
foreach($array as $key){
$keyboard[] = ['text'=>$key, 'callback_data'=>'data-'.$key];
}
$keyboards[] = $keyboard;
unset($keyboard);
}
return json_encode([
'inline_keyboard'=> $keyboards,
]);
}
function createKeyboardss($string1, $rows1 = 2, $orderBy1 = '|'){
$array1 = explode($orderBy1, $string1);
$arrays1 = array_chunk($array1, $rows1);
$keyboards1 = [];
foreach($arrays1 as $array1){
$keyboard1 = [];
foreach($array1 as $key1){
$keyboard1[] = ['text'=>$key1, 'callback_data'=>'data--'.$key1];
}
$keyboards1[] = $keyboard1;
unset($keyboard1);
}
return json_encode([
'inline_keyboard'=> $keyboards1,
]);
}
function showRules($chat_id, $message_id) {
    $rules_text = "
    📚 *قوانین و حریم خصوصی*
    
    1. استفاده از ربات برای فعالیت‌های غیرقانونی ممنوع است.
    2. حریم خصوصی کاربران محترم شمرده می‌شود.
    3. هرگونه سوءاستفاده منجر به مسدودسازی خواهد شد.
    
    ✅ با کلیک روی دکمه زیر، قوانین را می‌پذیرید.
    ";

    bot('editMessagetext',[
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $rules_text,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => 'تایید قوانین', 'callback_data' => 'accept_rules']],
                [['text' => 'بازگشت', 'callback_data' => 'back']]
            ]
        ])
    ]);
}
// تابع دریافت اخبار از NewsAPI (طبق کدی که دادید)
function getNewsFromNewsAPI($query = 'economy', $language = 'en', $pageSize = 20) {
    global $newsApiKey;
    $url = "https://newsapi.org/v2/everything?q={$query}&language={$language}&pageSize={$pageSize}&apiKey={$newsApiKey}";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === false) {
        return null; // اگر درخواست شکست خورد
    }

    $data = json_decode($response, true);
    return isset($data['articles']) ? $data['articles'] : null;
}
function calculateSMA($chartData, $period = 10) {
    $smaValues = [];
    $closingPrices = array_column($chartData, 4); // مقدار Close هر کندل

    for ($i = 0; $i < count($closingPrices); $i++) {
        if ($i < $period - 1) {
            $smaValues[] = null; // مقدار کافی برای SMA وجود ندارد
        } else {
            $sum = array_sum(array_slice($closingPrices, $i - $period + 1, $period));
            $smaValues[] = $sum / $period;
        }
    }

    return $smaValues;
}
function calculateSTC($data, $shortPeriod = 10, $longPeriod = 23, $cyclePeriod = 10) {
    if (count($data) < $longPeriod) {
        return []; // داده کافی نیست
    }

    $stc = [];
    $shortMA = [];
    $longMA = [];
    $macd = [];

    // محاسبه میانگین متحرک کوتاه‌مدت و بلندمدت
    for ($i = 0; $i < count($data); $i++) {
        if ($i < $shortPeriod - 1) {
            $shortMA[] = null;
        } else {
            $slice = array_slice(array_column($data, 4), $i - ($shortPeriod - 1), $shortPeriod);
            $shortMA[] = array_sum($slice) / count($slice);
        }

        if ($i < $longPeriod - 1) {
            $longMA[] = null;
        } else {
            $slice = array_slice(array_column($data, 4), $i - ($longPeriod - 1), $longPeriod);
            $longMA[] = array_sum($slice) / count($slice);
        }

        // محاسبه MACD به‌صورت دستی
        if ($i < $longPeriod - 1) {
            $macd[] = null;
        } else {
            $macd[] = $shortMA[$i] - $longMA[$i];
        }
    }

    // محاسبه استوکاستیک بر روی MACD
    for ($i = 0; $i < count($macd); $i++) {
        if ($i < $cyclePeriod - 1 || $macd[$i] === null) {
            $stc[] = null;
            continue;
        }

        $slice = array_slice($macd, $i - ($cyclePeriod - 1), $cyclePeriod);
        $maxMacd = max($slice);
        $minMacd = min($slice);

        if ($maxMacd - $minMacd == 0) {
            $stc[] = 50; // مقدار پیش‌فرض در صورت نبود نوسان
        } else {
            $stc[] = (($macd[$i] - $minMacd) / ($maxMacd - $minMacd)) * 100;
        }
    }

    return $stc;
}
function updateUserReferrals($chatid, $referrer_id) {
    $userFile = "data/$chatid/user_data.json";
    $data = file_exists($userFile) ? json_decode(file_get_contents($userFile), true) : ['referrals' => 0, 'coins' => 0];
    
    if ($referrer_id && $referrer_id != $chatid) {
        $referrerFile = "data/$referrer_id/user_data.json";
        $referrerData = file_exists($referrerFile) ? json_decode(file_get_contents($referrerFile), true) : ['referrals' => 0, 'coins' => 0];
        $referrerData['referrals'] += 1;
        $referrerData['coins'] += 100; // فرض: هر زیرمجموعه ۱۰۰ سکه می‌دهد
        file_put_contents($referrerFile, json_encode($referrerData));
    }
}
function getBinanceChartData($symbol, $timeframe, $limit = 100) {
    $url = "https://api.binance.com/api/v3/klines?symbol=$symbol&interval=$timeframe&limit=$limit";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}
// تابع دریافت اهمیت خبر بر اساس عنوان و تازگی آن
function getNewsImportance($title, $publishedAt) {
    $titleWordCount = str_word_count($title); // تعداد کلمات عنوان
    $timeDifference = time() - strtotime($publishedAt); // اختلاف زمان بر حسب ثانیه
    $hoursDifference = $timeDifference / 3600; // تبدیل به ساعت

    if ($titleWordCount > 8 && $hoursDifference < 12) {
        return "🚨 فوری";
    } elseif ($titleWordCount > 8) {
        return "🔴 خیلی مهم";
    } elseif ($hoursDifference < 12) {
        return "🟡 جدید و مهم";
    } else {
        return "🟢 معمولی";
    }
}

function objectToArrays($object){
 if(!is_object($object) && !is_array($object)){
return $object;
}
if(is_object($object)){
 $object = get_object_vars($object);
 }
return array_map("objectToArrays", $object);
 }
function save($filename, $data){
$file = fopen($filename, 'w');
fwrite($file, $data);
fclose($file);
}
function SendDocument($chat_id, $document, $caption = null){
bot('SendDocument',[
'chat_id'=>$chat_id,
'document'=>$document,
'caption'=>$caption
]);
}
function EditMessageText($chat_id,$message_id,$text,$parse_mode,$disable_web_page_preview,$keyboard){
bot('editMessagetext',[
'chat_id'=>$chat_id,
'message_id'=>$message_id,
'text'=>$text,
'parse_mode'=>$parse_mode,
'disable_web_page_preview'=>$disable_web_page_preview,
'reply_markup'=>$keyboard
]);
}
 function SendVideo($chat_id,$video,$caption,$keyboard,$duration){
bot('SendVideo',[
'chat_id'=>$chatid,
'video'=>$video,
'caption'=>$caption,
'duration'=>$duration,
'reply_markup'=>$keyboard
]);
}
function SendPhoto($chat_id, $photo, $caption = null){
bot('SendPhoto',[
'chat_id'=>$chat_id,
'photo'=>$photo,
'caption'=>$caption
]);
}
function sendAction($chat_id, $action){
bot('sendChataction',[
'chat_id'=>$chat_id,
'action'=>$action]);
}
function deleteFolder($path){
if(is_dir($path) === true){
$files = array_diff(scandir($path), array('.', '..'));
foreach ($files as $file)
deleteFolder(realpath($path) . '/' . $file);
return rmdir($path);
}else if (is_file($path) === true)
return unlink($path);
return false;
}
function Forward($kojashe, $azkoja, $kodommsg){
bot('forwardmessage',[
'chat_id'=>$kojashe,
'from_chat_id'=>$azkoja,
'message_id'=>$kodommsg
]);
}
function LeaveChat($chat_id){
bot('LeaveChat',[
'chat_id'=>$chat_id
]);
}
function GetChat($chat_id){
bot('GetChat',[
'chat_id'=>$chat_id
]);
}
function AnswerCallbackQuery($callback_query_id,$text,$show_alert){
bot('answerCallbackQuery',[
'callback_query_id'=>$callback_query_id,
'text'=>$text,
'show_alert'=>$show_alert,
]);
}
function RandomString(){
$length=1;
$characters='1';
$string='';
for($p=0;$p<$length;$p++){
$string.=$characters[mt_rand(0,strlen($characters))];
}
return $string;
} 
//===============//
if(!is_dir('data'))
{@mkdir('data');}
if(!is_dir('pro'))
{@mkdir('pro');}
if(!is_dir('free'))
{@mkdir('free');}
unlink ("error_log");
//===============//

/*
نویسنده سورس شاتل تیم :)
دیباگ کننده سورس #سیگنور_مسعود :)
دیباگ این سورس 5 روز طول کشید پس منبع رو پاک کنی عابرو برات نمیزارم پس منبع خودتو میزنی همراه با منبع اصلی باشه :)
مشکلی چیزی داشتید پیوی زیر مراجعه فرمایید : 
( @jahanbots |♻️| @jahanbots )
*/
//===============//
$admin = "1444726566";
//ایدی عددی ادمین اصلی//
$channel = "signalica";
//ایدی کانال بدون @//
$supurtersata = "shyank";
//یوزرنیم پشتیبانی بدون @//
$channelphoto = "http://s6.uupload.ir/files/9014496_tcy.png";
//لینک بنر عکستون رواز سایت uupload.ir بزنید
//===============//
/*
نویسنده سورس شاتل تیم :)
دیباگ کننده سورس #سیگنور_مسعود :)
دیباگ این سورس 5 روز طول کشید پس منبع رو پاک کنی عابرو برات نمیزارم پس منبع خودتو میزنی همراه با منبع اصلی باشه :)
مشکلی چیزی داشتید پیوی زیر مراجعه فرمایید : 
( @jahanbots |♻️| @jahanbots )
*/
$userbot = bot('GetMe')->result->username;
$GetINFObot = json_decode(file_get_contents("https://api.telegram.org/bot".API_KEY."/getMe"));
$UserNameBot = $GetINFObot->result->username;
//===============/
$update = json_decode(file_get_contents('php://input'));
$message = $update->message;
$chat_id = $message->chat->id;
$from_id = $message->from->id;
mkdir("data/$from_id");
$message_id = $update->message->message_id;
$text = $update->message->text;
$first_name = $update->message->from->first_name;
$last_name = $update->message->from->last_name;
$username = $update->message->from->username;
$query = $update->callback_query;
$data = $query->data;
$messageid = $query->message->message_id;
$chatid = $query->message->chat->id;
$fromid = $query->message->from->id;
$callback_query_id = $query->id;
$firstname = $update->callback_query->message->chat->first_name;
$reply = $update->message->reply_to_message;
$forward_chat_username = $update->message->forward_from_chat->username;
$da = $update->message->reply_to_message->forward_from->id;
$coin = file_get_contents("data/$chatid/coin.txt");
$state = file_get_contents("data/$chat_id/state.txt");
$step = file_get_contents("data/$from_id/step.txt");
@$list = file_get_contents("data/users.txt");
$list12 = file_get_contents("data/users.txt");
@$sea = file_get_contents("data/$from_id/membrs.txt");
@$on = file_get_contents("data/on.txt");
$idpm = file_get_contents("data/$chat_id/idpm.txt");
$to =  file_get_contents("data/$from_id/to.txt");
$blocklist = file_get_contents("data/blocklist.txt");
$members = file_get_contents('Member.txt');
$memlist = explode("\n", $members);
$member = file_get_contents("data/$from_id/member.txt");
$user = json_decode(file_get_contents('data/'.$from_id.'/data.json'));
$buytext = file_get_contents("data/buytext.txt")?:"متن خرید تنظیم نشده است";
$mid = file_get_contents("data/mid.txt")?:"$supurtersata";
$blocklist = file_get_contents("data/blocklist.txt");
$rand = file_get_contents("data/$chat_id/rand.txt");
$rand12 = file_get_contents("data/$chat_id/rand12.txt");
$listpro =  file_get_contents("pro/listpro.txt");
$listpro12 =  file_get_contents("free/listpro12.txt");
$daryafti =  file_get_contents("data/$chatid/daryafti.txt");
$created =  file_get_contents("data/created.txt");
$created12 =  file_get_contents("data/created12.txt");
$exit = objectToArrays($nms);
$key = $exit[2][0];
$exitu = objectToArrays($nmsu);
$keyu = $exitu[2][0];
$GetINFObot = json_decode(file_get_contents("https://api.telegram.org/bot".API_KEY."/getMe"));
$UserNameBot = $GetINFObot->result->username;
$NameBot = $GetINFObot->result->first_name;
$inch = file_get_contents("https://api.telegram.org/bot".API_KEY."/getChatMember?chat_id=@$channel&user_id=".$from_id);
$inch1 = file_get_contents("https://api.telegram.org/bot".API_KEY."/getChatMember?chat_id=@$channel&user_id=".$chatid);
$satashop= json_decode(file_get_contents("http://app-5.ir/api/ch.php?channel=$channel"),true);
$link = $satashop["Result"];
$Main = $link["Main_Information"];
$channelnamee = $Main["Channel_Title"];
$signorshop= json_decode(file_get_contents("http://app-5.ir/api/ch.php?channel=$userbot"),true);
$linkBOT = $signorshop["Result"];
$rulesAccepted = file_get_contents("data/$chatid/rules_accepted.txt");
$MainBOT = $linkBOT["Main_Information"];
$kelid = file_get_contents("data/$chatid/1/dluserr.txt");
$botname = $MainBOT["Channel_Title"];
/*
نویسنده سورس شاتل تیم :)
دیباگ کننده سورس #سیگنور_مسعود :)
دیباگ این سورس 5 روز طول کشید پس منبع رو پاک کنی عابرو برات نمیزارم پس منبع خودتو میزنی همراه با منبع اصلی باشه :)
مشکلی چیزی داشتید پیوی زیر مراجعه فرمایید : 
( @jahanbots |♻️| @jahanbots )
*/
//===============================================================//

//=========//
$joinmenu = json_encode(['inline_keyboard'=>[
[['text'=>"$channelnamee",'url'=>"https://t.me/$channel"]],
[['text'=>"🔰|ɪ'ᴍ ᴊᴏɪɴ ᴄʜᴀɴɴᴇʟ|🔰",'url'=>"https://t.me/$userbot?start=start"]],
],'resize_keyboard'=>true]);
$market_analysis_menu = json_encode(['inline_keyboard' => [
    [['text' => "تحلیل بازار کریپتو 📊", 'callback_data' => "c_anal"]],
    [['text' => "تحلیل بازار فارکس 💹", 'callback_data' => "forex_analysis"]],
    [['text' => "بازگشت ↩️", 'callback_data' => "back"]],
], 'resize_keyboard' => true]);
//=========//
if ($chatid == $admin or $from_id == $admin){
$menu = json_encode(['inline_keyboard'=>[
[['text'=>"فروشگاه 🏪", 'callback_data'=>"vitrin"],
['text'=>"فروشگاه رایگان 🗳", 'callback_data'=>"freepro"]],
[['text'=>"تحلیل", 'callback_data'=>"market_analysis"],
['text'=>" آخرین اخبار اقتصادی 📰", 'callback_data'=>"latest_news"]],
[['text'=>"هوش مصنوعی", 'callback_data'=>"ai_analysis"],
['text'=>"اخرین تغیرات", 'callback_data'=>"latest_changes"]],
[['text'=>"دریافتی شما 🎡", 'callback_data'=>"daryafti"],
['text'=>"حساب من 🔖", 'callback_data'=>"hesab"]],
[['text'=>"پشتیبانی 👨🏻‍💻", 'callback_data'=>"sup"],
['text'=>"سرمایه گذاری 💳", 'callback_data'=>"sabt12"]],
[['text'=>"🌐ورود به مدیریت🌐", 'callback_data'=>"modirm"]],
],'resize_keyboard'=>true]);
}else {
$menu = json_encode(['inline_keyboard'=>[
[['text' => "💰 ایردراپ رایگان", 'callback_data' => "airdrop_menu"],
['text' => "🛒 فروشگاه NFT", 'callback_data' => "nft_shop"]],
[['text' => "ابزار های ربات 🛠", 'callback_data' => "special_button"],
['text'=>"حساب من 🔖", 'callback_data'=>"hesab"]],
[['text'=>"فروشگاه 🏪", 'callback_data'=>"vitrin"],
['text'=>"قوانین و حریم خصوصی 🪪", 'callback_data'=>"show_rules"]],
[['text'=>"پشتیبانی 👨🏻‍💻", 'callback_data'=>"sup"],
['text'=>"سرمایه گذاری 💳", 'callback_data'=>"sabt12"]],
[['text' => "معرفی ربات 🤖", 'callback_data' => "about_bot"]],
],'resize_keyboard'=>true]);}
//=========//
$back2menu = json_encode(['inline_keyboard'=>[
[['text'=>"برگشت ↩️",'callback_data'=>"back"]],
],'resize_keyboard'=>true]);
//=========//
$myinfomenu = json_encode(['inline_keyboard'=>[
[['text'=>"📌 نام",'callback_data'=>"signorshop"],['text'=>"$firstname",'callback_data'=>"signorshop"]],
[['text'=>"📍 آیدی",'callback_data'=>"signorshop"],['text'=>"$chatid",'callback_data'=>"signorshop"]],
[['text'=>"💵 بالانس",'callback_data'=>"signorshop"],['text'=>"$coin",'callback_data'=>"signorshop"]],
[['text'=>"🪪 وضعیت قوانین",'callback_data'=>"signorshop"],['text' =>"$rulesAccepted",'callback_data'=>"signorshop"]],
[['text'=>"🗳 محصولات شما", 'callback_data'=>"daryafti"],
['text'=>"👤 زیرمجموعه گیری",'callback_data'=>"banner"]],
[['text'=>"برگشت ↩️",'callback_data'=>"back"]],
],'resize_keyboard'=>true]);
//=========//
//=========//
if ($chatid == $admin){
$modiriyat = json_encode(['inline_keyboard'=>[
[['text'=>"آمار 🔖" , 'callback_data'=>"amar"],
['text'=>"مدیریت محصول 🏪" , 'callback_data'=>"sabt"]],
[['text' => "فعال‌سازی 🔓", 'callback_data' => "activate_button"],
['text' => "غیرفعال‌سازی 🔒", 'callback_data' => "deactivate_button"]],
[['text'=>"پیام همگانی 📬" , 'callback_data'=>"pmall"],
['text'=>"فورارد همگانی 🗃" , 'callback_data'=>"forall"]],
[['text'=>"متن فروش سکه 🏟" , 'callback_data'=>"textsek"],
['text'=>"تنظیم ایدی مدیر 👨🏻‍💻" , 'callback_data'=>"idmodir"]],
[['text'=>"سکه به کاربر 💰" , 'callback_data'=>"score"],
['text'=>"صفر کردن سکه 🚯" , 'callback_data'=>"sefr"]],
[['text'=>"راهنمای ربات 🎩" , 'callback_data'=>"rah"],
['text'=>"سکه همگانی 💡" , 'callback_data'=>"scoreall"]],
[['text'=>"بلاک کردن 🔫" , 'callback_data'=>"block"],
['text'=>"آنبلاک کردن 🔪" , 'callback_data'=>"unblock"]],
[['text'=>"🔰بازگشت به کاربری🔰",'callback_data'=>"back"]],
],'resize_keyboard'=>true]);
}
if ($chatid == $admin){
$back2modiriyat = json_encode(['inline_keyboard'=>[
[['text'=>'برگشت ↩️' , 'callback_data'=>"2"]],
],'resize_keyboard'=>true]);
}
//===============================================================//
/*
نویسنده سورس شاتل تیم :)
دیباگ کننده سورس #سیگنور_مسعود :)
دیباگ این سورس 5 روز طول کشید پس منبع رو پاک کنی عابرو برات نمیزارم پس منبع خودتو میزنی همراه با منبع اصلی باشه :)
مشکلی چیزی داشتید پیوی زیر مراجعه فرمایید : 
( @jahanbots |♻️| @jahanbots )
*/
//=========//
if(strpos($blocklist, "$from_id") !== false ){
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
شما به دلیل رعایت نکردن قوانین از بات بلاک شدید ❌
",
'reply_markup'=>json_encode([
'remove_keyboard'=>true,
])
]);
}
//==========//
elseif($text=="/start"){
if(strpos($inch,'"status":"left"')== true){ 
bot('sendmessage',[
'chat_id'=>$chat_id,
'disable_web_page_preview'=>true,
'text'=>"
🚦جهت حمایت از ما و اطلاع از آپدیت های ربات در کانال ما عضو شوید!!

🚧 @$channel  ||  @$channel

🅿️ سپس به ربات برگشته و بر روی عضو شدم ✅ کلیک کنید!!
",
'parse_mode'=>"html",  
'reply_markup' => $joinmenu ]);
}else{
bot('sendmessage', [
'chat_id' => $chat_id,
'text' => "سلام و وقت بخیر! 🌟
به ربات سمفونی پروفیت خوش آمدید! 🎼💹

اینجا می‌تونید با استفاده از ابزارهای پیشرفته تحلیل بازار، تصمیم‌های هوشمندانه‌تری بگیرید. چه به دنبال تحلیل ارزهای دیجیتال باشید، چه بازارهای جهانی، ما در کنار شما هستیم تا بهترین سیگنال‌ها و اطلاعات را در اختیارتان قرار دهیم.

✨ امکانات ربات:

تحلیل لحظه‌ای بازارهای مالی 💰
سیگنال‌های خرید و فروش بر اساس اندیکاتورهای پیشرفته 📈📉
تحلیل با هوش مصنوعی 🤖
مشاهده و سفارش محصولات مرتبط با بازارهای مالی 🛍

اگر سوالی دارید یا به راهنمایی نیاز دارید، فقط کافیه گزینه پشتیبانی را انتخاب کنید.
ما اینجاییم تا به شما کمک کنیم بهترین تصمیم‌ها رو بگیرید! 🚀

به خانواده سمفونی پروفیت خوش آمدید! 🎉
☑️ کانال ما :
🆔 @$channel
",
'parse_mode' => "HTML",
'reply_markup' => $menu ]);
$user = file_get_contents('data/users.txt');
$members = explode("\n", $user);
if(!in_array($from_id, $members)){
$add_user = file_get_contents('data/users.txt');
$add_user .= $from_id . "\n";
file_put_contents("data/$chat_id/membrs.txt", "0");
file_put_contents("data/$chat_id/coin.txt", "0");
file_put_contents('data/users.txt', $add_user);
}
}
file_put_contents("data/$chat_id/state.txt","no");
}

//========//
elseif(strpos($text , '/start ') !== false){
$chid = str_replace("/start ","",$text);
if(strpos($inch,'"status":"left"')== true){ 
bot('sendmessage',[
'chat_id'=>$chat_id,
'disable_web_page_preview'=>true,
'text'=>"
🚦جهت حمایت از ما و اطلاع از آپدیت های ربات در کانال ما عضو شوید!!

🚧 @$channel  ||  @$channel

🅿️ سپس به ربات برگشته و بر روی عضو شدم ✅ کلیک کنید!!
",
'parse_mode'=>"html",  
'reply_markup'=>json_encode([
'resize_keyboard'=>true,
'inline_keyboard'=>[
[['text'=>"$channelnamee",'url'=>"https://t.me/$channel"]],
[['text'=>"🔰|ɪ'ᴍ ᴊᴏɪɴ ᴄʜᴀɴɴᴇʟ|🔰",'url'=>"https://t.me/$userbot?start=$chid"]],
]
])
]);
}else{
$user = file_get_contents('data/users.txt');
$exit = explode("\n", $user);
if($from_id != $chid){
if(!in_array($from_id,$exit) && $from_id != $chid){
$myfile2 = fopen("data/users.txt", "a") or die("Unable to open file!");
fwrite($myfile2, "$from_id\n");
fclose($myfile2);
file_put_contents("data/$chat_id/membrs.txt", "0");
file_put_contents("data/$chat_id/coin.txt", "0");
@$sho = file_get_contents("data/$chid/coin.txt");
$getsho = $sho + 1;
file_put_contents("data/$chid/coin.txt", $getsho);
@$sea = file_get_contents("data/$chid/membrs.txt");
$getsea = $sea + 1;
file_put_contents("data/$chid/membrs.txt", $getsea);
file_put_contents("data/$chat_id/state.txt","no");
bot('sendMessage',[
'chat_id'=>$chid,
'text'=>"[یک کاربر](tg://user?id=$from_id) از طریق لینک شما وارد ربات شد😍",
'parse_mode'=>"markdown",
]);
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"سلام و وقت بخیر! 🌟
به ربات سمفونی پروفیت خوش آمدید! 🎼💹

اینجا می‌تونید با استفاده از ابزارهای پیشرفته تحلیل بازار، تصمیم‌های هوشمندانه‌تری بگیرید. چه به دنبال تحلیل ارزهای دیجیتال باشید، چه بازارهای جهانی، ما در کنار شما هستیم تا بهترین سیگنال‌ها و اطلاعات را در اختیارتان قرار دهیم.

✨ امکانات ربات:

تحلیل لحظه‌ای بازارهای مالی 💰
سیگنال‌های خرید و فروش بر اساس اندیکاتورهای پیشرفته 📈📉
تحلیل با هوش مصنوعی 🤖
مشاهده و سفارش محصولات مرتبط با بازارهای مالی 🛍

اگر سوالی دارید یا به راهنمایی نیاز دارید، فقط کافیه گزینه پشتیبانی را انتخاب کنید.
ما اینجاییم تا به شما کمک کنیم بهترین تصمیم‌ها رو بگیرید! 🚀

به خانواده سمفونی پروفیت خوش آمدید! 🎉
☑️ کانال ما :
🆔 @$channel
",
'parse_mode'=>"html",
'reply_markup' => $menu ]);
}else{
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"شما قبلا عضو ربات شدید️"
]);
}
}else{
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"🚫 عدم امکان استفاده از لینک دعوت

متأسفیم، اما شما در حال حاضر نمی‌توانید از لینک دعوت خود برای جذب زیرمجموعه استفاده کنید."
]);
}
}
}
//=========//
elseif(strpos($inch1,'"status":"left"')== true){ 
 bot('answercallbackquery',[
'callback_query_id'=>$callback_query_id,
'text'=>"
⭕️ʏᴏᴜ ᴀʀᴇ ʟᴇꜰᴛ ᴛʜᴇ ᴄʜᴀɴɴᴇʟ
⭕️ꜰɪʀꜱᴛ ᴊᴏɪɴ ᴛᴏ : @$channel
⭕️ᴀɴᴅ ꜰɪɴᴀʟʟʏ /ꜱᴛᴀʀᴛ ᴏʀ ᴡᴏʀᴋ ʙᴏᴛ
",
'parse_mode'=>"html",
'show_alert'=>true,
]);
}   
//=========//
elseif($data == "freepro"  ){
if($created12 == "ok"){
file_put_contents("data/$chatid/state.txt","none");
$listpro12 =  file_get_contents("free/listpro12.txt");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"
⚖️ لیست اشتراک های سفمونی پروفیت به شرح زیر میباشد :",
'parse_mode'=>"html",  
'reply_markup'=>createKeyboard(file_get_contents("free/listpro12.txt"),'2',"\n")
]);
}else{
bot('answercallbackquery',[
'callback_query_id'=>$callback_query_id,
'text'=>"محصولی در فروشگاه وجود ندارد 🚧",
]);
}
}
elseif(strpos($text,"/free_" ) !== false ){
$exitu = explode("_",$text);
$key21 = $exitu[1];
$proname12 = file_get_contents("free/$key21/proname12.txt");
$expro12 = file_get_contents("free/$key21/expro12.txt");
$dlfile12 = file_get_contents("free/$key21/dlfile12.txt");
bot('senddocument',[
'chat_id'=>$chat_id,
'document'=>$dlfile12,
'caption'=>"
💠نام محصول : $proname12

📝 توضیحات : $expro12

🧾 کد محصول : $key21

💎 کانال ما :
🧧@$channel
",
'parse_mode' => "HTML",
]);
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
این محصول رایگان میباشد 💡
",
'parse_mode' => "HTML",
'reply_markup' => $back2menu ]);}
//=========//
elseif($data == "vitrin" ){
if($created == "ok"){
file_put_contents("data/$chatid/state.txt","none");
$listpro =  file_get_contents("pro/listpro.txt");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"⚖️ لیست اشتراک های سفمونی پروفیت به شرح زیر میباشد :",
'parse_mode'=>"html",  
'reply_markup'=>createKeyboardss(file_get_contents("pro/listpro.txt"),'2',"\n")
]);
}else{
bot('answercallbackquery',[
'callback_query_id'=>$callback_query_id,
'text'=>"محصولی در فروشگاه وجود ندارد 🚧",
]);
}
}
elseif(strpos($data,"data--" ) !== false ){
preg_match_all("/data--(.*)-(.*)/",$data,$nms);
$exit = objectToArrays($nms);
$key = $exit[2][0];
bot('editMessagetext', [
'chat_id' => $chatid,
'message_id'=>$messageid,
'text' => "
🔖برای دریافت اطلاعات بیشتر در مورد محصول دریافتی بر روی دکمه زیر بزنید.

📂  /info_$key

💾 در غیر این صورت محصول دیگری از منوی زیر انتخاب کنید .
",
'parse_mode' => "HTML",
'reply_markup'=>createKeyboardss(file_get_contents("pro/listpro.txt"),'2',"\n")
]);
}
elseif(strpos($data,"data-" ) !== false ){
preg_match_all("/data-(.*)--(.*)/",$data,$nmsu);
$exitu = objectToArrays($nmsu);
$keyu = $exitu[2][0];
bot('editMessagetext', [
'chat_id' => $chatid,
'message_id'=>$messageid,
'text' => "
🔖برای دریافت اطلاعات بیشتر در مورد محصول دریافتی بر روی دکمه زیر بزنید.

📂  /free_$keyu

💾 در غیر این صورت محصول دیگری از منوی زیر انتخاب کنید .
",
'parse_mode' => "HTML",
'reply_markup'=>createKeyboard(file_get_contents("free/listpro12.txt"),'2',"\n")
]);
}
elseif(strpos($text,"/info_" ) !== false ){
$exit = explode("_",$text);
$key20 = $exit[1];
$proname1 = file_get_contents("pro/$key20/proname.txt");
$expro1 = file_get_contents("pro/$key20/expro.txt");
$sekpro1 = file_get_contents("pro/$key20/sekpro.txt");
$polpro1 = file_get_contents("pro/$key20/polpro.txt");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
💠 نام محصول : $proname1

📝 توضیحات : $expro1

💰قیمت محصول : $polpro1 تتر

🧾 کد محصول : $key20
",
'parse_mode' => "HTML",
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>"خرید محصول 💵",'callback_data'=>"send|$key20"],['text'=>"شارژ حساب 💴",'url'=>"https://t.me/$mid"]],
[['text'=>"برگشت ↩️",'callback_data'=>"back"]],
],
'resize_keyboard'=>true,
])
]);
}
elseif(strpos($data,"send|" ) !== false ){
$exit = explode("|",$data);
$key1 = $exit[1];
$sekpro2 = file_get_contents("pro/$key1/sekpro.txt");
$coin = file_get_contents("data/$chatid/coin.txt");
if($coin >= $sekpro2){
$proname2 = file_get_contents("pro/$key1/proname.txt");
$expro2 = file_get_contents("pro/$key1/expro.txt");
$dlfile2 = file_get_contents("pro/$key1/dlfile.txt");
$coin = file_get_contents("data/$chatid/coin.txt");
$sekpro2 = file_get_contents("pro/$key1/sekpro.txt");
settype($coin,"integer");
$newcoin = $coin - $sekpro2;
file_put_contents("data/$chatid/coin.txt","$newcoin");
bot('senddocument',[
'chat_id'=>$chatid,
'document'=>$dlfile2,
'caption'=>"
💠نام محصول : $proname2

📝 توضیحات : $expro2

💡 کانال ما :
🆔 @$channel
",
'parse_mode' => "HTML",
]);
bot('sendmessage',[
'chat_id'=>$chatid,
'text'=>"
شما محصول با کد $key1 را دریافت کردید ✅

تعداد $sekpro2 از حساب شما کسر شد 💁🏻‍♂
",
'parse_mode' => "HTML",
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>'برگشت ↩️', 'callback_data'=>"back"]],
],
'resize_keyboard'=>true,
])
]);
$rnd = RandomString();
mkdir("data/$chatid/$rnd");
file_put_contents("data/$chatid/$rnd/dluserr.txt","$dlfile2");
$listprouser =  file_get_contents("data/$chatid/listprouser.txt");
$myfile1 = fopen("data/$chatid/listprouser.txt", "a") or die("Unable to open file!");
fwrite($myfile1, "$proname2|/dl_$rnd \n");
fclose($myfile1);
file_put_contents("data/$chatid/daryafti.txt","ok");
file_put_contents("data/$chatid/state.txt","none");
}else{
file_put_contents("data/$chatid/step.txt","none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
❌ سکه شما جهت دریافت محصول کافی نمیباشد.
🔰تعداد سکه شما : $coin
✅ از بخش حساب کاربری سکه تو افزایش بده.
",
'reply_markup' => $back2menu ]);}}
//==========//
elseif($data == "back" ){
file_put_contents("data/$chatid/state.txt","none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"سلام و وقت بخیر! 🌟
به ربات سمفونی پروفیت خوش آمدید! 🎼💹

اینجا می‌تونید با استفاده از ابزارهای پیشرفته تحلیل بازار، تصمیم‌های هوشمندانه‌تری بگیرید. چه به دنبال تحلیل ارزهای دیجیتال باشید، چه بازارهای جهانی، ما در کنار شما هستیم تا بهترین سیگنال‌ها و اطلاعات را در اختیارتان قرار دهیم.

✨ امکانات ربات:

تحلیل لحظه‌ای بازارهای مالی 💰
سیگنال‌های خرید و فروش بر اساس اندیکاتورهای پیشرفته 📈📉
تحلیل با هوش مصنوعی 🤖
مشاهده و سفارش محصولات مرتبط با بازارهای مالی 🛍

اگر سوالی دارید یا به راهنمایی نیاز دارید، فقط کافیه گزینه پشتیبانی را انتخاب کنید.
ما اینجاییم تا به شما کمک کنیم بهترین تصمیم‌ها رو بگیرید! 🚀

به خانواده سمفونی پروفیت خوش آمدید! 🎉
☑️ کانال ما :
🆔 @$channel
",
'parse_mode'=>"html",  
'reply_markup' => $menu ]);
}
//==========//
elseif($data == "daryafti"){
if($daryafti == "ok"){
$listprouser =  file_get_contents("data/$chatid/listprouser.txt");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"
🧧 محصولات دریافتی شما به شرح زیر میباشد .

نام محصول 📝 | کد محصول 🧾

$listprouser
",
'reply_markup' => $back2menu ]);
}else{
bot('answercallbackquery',[
'callback_query_id'=>$callback_query_id,
'text'=>"شما محصولی تا حالا دریافت نکردید 🚫",
]);
}
}
elseif(strpos($text,"/dl_" ) !== false ){
$exit = explode("_",$text);
$keyu = $exit[1];
$dluserr =  file_get_contents("data/$chat_id/$keyu/dluserr.txt");
bot('senddocument',[
'chat_id'=>$chat_id,
'document'=>$dluserr,
'caption'=>"",
]);
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
فایل شما 👆🏻
",
'reply_markup' => $back2menu ]);}
//=========//
elseif(strpos($blocklist, "$chatid") !== false){
bot('answercallbackquery',[
'callback_query_id'=>$callback_query_id,
'text'=>"شما از ربات بلاک شده اید",
'parse_mode'=>"html",
'reply_markup'=>json_encode([
'KeyboardRemove'=>[],'remove_keyboard'=>true
])
]);
}
//=========//
elseif($data == "hesab" ){
file_put_contents("data/$chatid/state.txt","none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"🔑 به حساب کاربری خود خوش آمدید !

 👇🏻برای شروع از منوی زیر اقدام نمایید :",
'parse_mode'=>"html",  
'reply_markup' => $myinfomenu ]);}
elseif($data == "banner" ){
file_put_contents("data/$chatid/state.txt","none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"
📷 برای دریافت بنر زیر مجموعه گیری بر روی دکمه اشتراک گزاری زیر بزنید .

⭕️ یا میتوانید در هر جا با استفاده از متن زیر بنر خود را دریافت کنید.

<pre>@$UserNameBot inline_banner</pre>
",
'parse_mode'=>"html",  
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>"اشتراک گزاری 📌",'switch_inline_query'=>"inline_banner"]],
[['text'=>"برگشت ↩️",'callback_data'=>"back"]],
],
'resize_keyboard'=>true,
])
]);
}

elseif(isset($update->inline_query) and $update->inline_query->query == 'inline_banner'){
bot('answerInlineQuery',array(
'inline_query_id' => $update->inline_query->id,
'cache_time' => 1,
'results' => json_encode(array(array(
'type' => 'article',
'id' => base64_encode(rand(0,999)),
'thumb_url' => '',
'title' => '📊 برای اشتراک گذاری کلیک کنید',
'parse_mode'=> 'MarkDown',
'input_message_content' => array('parse_mode' => 'html', 'message_text' => "
اینجا می‌تونید با استفاده از ابزارهای پیشرفته تحلیل بازار، تصمیم‌های هوشمندانه‌تری بگیرید. چه به دنبال تحلیل ارزهای دیجیتال باشید، چه بازارهای جهانی، ما در کنار شما هستیم تا بهترین سیگنال‌ها و اطلاعات را در اختیارتان قرار دهیم.

✨ امکانات ربات:

تحلیل لحظه‌ای بازارهای مالی 💰
سیگنال‌های خرید و فروش بر اساس اندیکاتورهای پیشرفته 📈📉
تحلیل با هوش مصنوعی 🤖
مشاهده و سفارش محصولات مرتبط با بازارهای مالی 🛍
ما اینجاییم تا به شما کمک کنیم بهترین تصمیم‌ها رو بگیرید! 🚀

سازنده ربات: @SIGNALICA

🔗 https://t.me/$userbot?start=".$update->inline_query->from->id,
)),array(
'type' => 'photo',
'id' => base64_encode(rand(0,999)),
'photo_url' => "$channelphoto",
'thumb_url' => "$channelphoto",
'caption' => "
🛍 ربات $botname آنلاین

💡 دارای بخش رایگان محصولات
💎 خرید پکیج های آموزشی
🧾 محصولات پاپ نشده 
🧸 دریافت روزانه محصولات رایگان
🏪 فروشگاه آنلاین 24 ساعته

🔑 اگه میخوای همه اینارو داشته باشی فقط ربات زیر رو استارت کن!!!

🔗https://t.me/$userbot?start=".$update->inline_query->from->id,
'title' => 'برای اشتراک گذاشتن بنر روی عکس زیر کلیک کنید',
'reply_markup' => array('inline_keyboard'=>array(
array(array('text'=>'اشتراک گذاری📌','switch_inline_query'=>'inline_banner'))
))
)
))
));
}
elseif($data == "about_bot" ){
file_put_contents("data/$chatid/state.txt","none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"🚀 *Symphony Profit - ربات تحلیل هوشمند بازار*

✨ ویژگی‌های کلیدی:

▫️ 📊 تحلیل تکنیکال حرفه‌ای با ۳۰+ اندیکاتور

‌‌‌‌☑️ RSI • MACD • Bollinger Bands • Ichimoku

‌‌‌‌☑️ Fibonacci • Volume Profile • Market Profile


▫️ 📰 دسترسی زنده به اخبار:

‌‌‎ ‎🌐 CoinDesk • CoinTelegraph • CryptoSlate

‌‌‎ ‎📡 فیدهای خبری با اولویت‌بندی هوش مصنوعی


▫️ ⚡️ قابلیت‌های ویژه:

‌‌‎ ‎🔔 هشدارهای قیمتی چندشرطی

‌‌‎ ‎📈 تشخیص الگوهای هارمونیک خودکار

‌‌‎ ‎🤖 تحلیل سانتیمنتال با Deep Learning


🔍 داده‌های بازار:

‌‌‌‌✅ دامیننس BTC/ETH در لحظه

‌‌‌‌✅ حجم معاملات ۵۰ صرافی برتر

‌‌‌‌✅ نوسانات تاریخی و پیش‌بینی


🛠 پلتفرم:

‌‌‌‌🔸 نسخه: 1 (آخرین آپدیت)

‌‌‌‌🔸 پشتیبانی ۲۴/۷ 

‌‌‌‌🔸 سرورهای اختصاصی در ۵ منطقه زمانی


📌 برای شروع از /start استفاده کنید
🔄 هر ۳۰ دقیقه آپدیت خودکار داده‌ها",
'parse_mode'=>"html",  
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text' => '📚 آموزش ویدیویی', 'url' => 'https://t.me/Signalica'],
['text' => '🌐 وبسایت', 'url' => 'https://t.me/Signalica']],
[['text'=>"برگشت ↩️",'callback_data'=>"back"]],
],
'resize_keyboard'=>true,
])
]);
}
//===========//
elseif($data == "sabt12" ){
file_put_contents("data/$chatid/state.txt","none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"
🚀 سود ۱۰٪ در ماه! 🚀  
💰 سرمایه‌گذاری هوشمند، سود تضمینی! 💰  

🎯 آیا به دنبال یک فرصت سرمایه‌گذاری با بازدهی فوق‌العاده هستید؟  
با ربات سرمایه‌گذاری ما، ماهانه ۱۰٪ سود دریافت کنید!   

✨ چرا ما؟  
- سود ماهانه ثابت و تضمینی  
- مدیریت حرفه‌ای و مطمئن  
- شروع سرمایه‌گذاری با حداقل مبلغ  

📈 فرصت را از دست ندهید!  
همین حالا به ربات ما بپیوندید و سرمایه‌گذاری پرسود را شروع کنید.  

💬 برای اطلاعات بیشتر، پیام دهید یا با پشتیبانی ما تماس بگیرید.",
'parse_mode'=>"html",  
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>"ارتباط با مدیر 💁🏻‍♂",'url'=>"t.me/$mid"]],
[['text'=>"برگشت ↩️",'callback_data'=>"back"]],
],
'resize_keyboard'=>true,
])
]);
}
//==========//
elseif($data =="sup"){
file_put_contents("data/$chatid/state.txt","mok");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"👋 سلام عزیز!

🌟 ما اینجاییم تا به شما کمک کنیم. 
اگر سوالی دارید، نظری می‌خواهید بدهید، پیشنهادی برای بهبود دارید یا با مشکلی مواجه شده‌اید، تیم پشتیبانی ما آماده شنیدن و پاسخگویی به شماست.

🕒  پشتیبانی ۲۴/۷
تیم ما به‌صورت شبانه‌روزی آماده خدمت‌رسانی به شماست.

💬 پیام‌های شما برای ما ارزشمند است و در سریع‌ترین زمان ممکن پاسخ داده خواهد شد.

👇 لطفاً نظر، پیشنهاد یا مشکل خود را اینجا بنویسید :",
'reply_markup' => $back2menu ]);}
elseif($state == "mok"){
file_put_contents("data/$chat_id/state.txt","no");
bot('sendMessage',[
'chat_id'=>$admin,
'text'=>"
💡مدیر  یک پیام با اطلاعات زیر داری:
نام کاربر : $firstname
ایدی کاربر: @$username
ایدی عددی کاربر : <pre>$from_id</pre>
🚦 متن پیام :
- - - - - - - - - - - -
$text

",
'parse_mode'=>'html',
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>"پاسخ به کاربر 💡",'callback_data'=>"pm|$from_id"]],
],
'resize_keyboard'=>true,
])
]);
bot('sendMessage',[
'chat_id'=>$chat_id,
'text'=>"✅ پیام شما با موفقیت به تیم پشتیبانی ارسال شد و در سریع‌ترین زمان ممکن بررسی خواهد شد.

🌟 ممنون که با ما در ارتباط هستید. 

⏳ لطفاً کمی صبر کنید...
به زودی پاسخ شما را خواهیم داد.",
'reply_markup' => $back2menu ]);}
elseif(strpos($data,"pm|" ) !== false ){
$exit = explode("|",$data);
$key = $exit[1];
file_put_contents("data/$chatid/info.txt","$key");
file_put_contents("data/$chatid/state.txt","pm1");
bot('sendMessage',[
'chat_id'=>$admin,
'text'=>"
شما در حال پاسخ به ایدی $key هستید 🛡
",
'parse_mode'=>'html',
]);
}
elseif($state == "pm1"){
file_put_contents("data/$from_id/sendpm.txt","$text");
file_put_contents("data/$chat_id/state.txt","no");
$info = file_get_contents("data/$from_id/info.txt");
$sendpm = file_get_contents("data/$from_id/sendpm.txt");
bot('sendMessage',[
'chat_id'=>$info,
 'text'=>"
 👋 سلام عزیز !

🌟 ممنون که با ما در ارتباط بودید.
پیام شما توسط تیم پشتیبانی بررسی شد و پاسخ آن به شرح زیر است  :

$sendpm
",
'parse_mode'=>'MarkDown',
]);
bot('sendMessage',[
'chat_id'=>$chat_id,
'text'=>"ارسال شد ✅",
]);
}
//==========//
elseif($data == "pos" ){
file_put_contents("data/$chatid/state.txt","none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"
وضعیت حساب شما به شرح زیر میباشد 💡
",
'parse_mode'=>"html",  
'reply_markup' => $myaccmenu ]);
}
//==========//
elseif($data == "buy" ){
file_put_contents("data/$chatid/state.txt","none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"
$buytext
",
'parse_mode'=>"html",  
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>"ارتباط با مدیر 💁🏻‍♂",'url'=>"t.me/$mid"]],
[['text'=>"برگشت ↩️",'callback_data'=>"back"]],
],
'resize_keyboard'=>true,
])
]);
}
//==========//
elseif($data=="signorshop"){
file_put_contents("data/$from_id/step.txt","none");
bot('answercallbackquery',[
'callback_query_id'=>$callback_query_id,
'text'=>"این دکمه صرفا نمایشی است ❗️",
]);
}


//=========//
elseif($data == "modirm" or $data == "2" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"به پنل مدیریتی ربات $botname خوش آمدید ⛳️",
'parse_mode'=>'html',
'reply_markup' => $modiriyat ]);
}
//========//
elseif($data == "rah" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
💾 راهنمای ربات $botname آنلاین

💯 لطفا مراحل زیر را به دقت اجرا کنید تا ربات به درستی کار شود.

1⃣  ابتدا لازم است ایدی مدیر و متن فروش سکه را تنظیم نمایید.

2⃣ برای اینکه بنر ربات $botname کار کند شما باید در @botfather به بخش botsetting رفته و حالت inline mode را در حالت on روشن قرار بدید سپس در همان بخش inline feedback را روی 100 درصد بزارید با این کار بنر اینلاین ربات شما فعال میشود.

3⃣ در هنگام ثبت محصولات استفاده از نام های طولانی در نام محصول خودداری فرمایید.

4⃣ در هنگام ثبت محصول فقط از فایل های Zip استفاده کنید تا به درستی محصول ثبت شود.

5⃣ شما میتوانید با ویژه شدن تبلیغات در ربات خود را حذف کنید.

6️⃣نویسنده این سورس شاتل تیم می باشد

7️⃣دیباگ کردن این ربات 5 روز طول کشید پس اگر بفهمم روزی لینک منو از پنل مدیریت پاک کردی ناموستو همراه با تمام عابروت میگام #سیگنور_مسعود

8️⃣سوالی مشکلی داشتید بنده درخدمتم @jahanbots ",
'parse_mode'=>'html',
'reply_markup' => $back2modiriyat ]);}

elseif($data == "sabt" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"به بخش ثبت محصول خوش آمدید 🌹",
'parse_mode'=>'html',
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>'محصول ویژه ⭐️' , 'callback_data'=>"sabtnew"],['text'=>'حذف محصول ویژه 🌓' , 'callback_data'=>"delsabt"]],
[['text'=>'محصول رایگان 🔑' , 'callback_data'=>"freepro13"],['text'=>'حذف محصول رایگان 📮' , 'callback_data'=>"delprofree"]],
[['text'=>'برگشت ↩️' , 'callback_data'=>"2"]],
],
'resize_keyboard'=>true
])
]);
}
elseif($data == "delprofree" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
از منوی زیر انتخاب کنید 🌼
",
'parse_mode'=>'html',
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>'حذف' , 'callback_data'=>"delsabt12"],['text'=>'حذف کلی محصولات' , 'callback_data'=>"hafiiall12"]],
[['text'=>'برگشت ↩️' , 'callback_data'=>"2"]],
],
'resize_keyboard'=>true
])
]);
}
elseif($data == "hafiiall12" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
unlink("free/listpro12.txt");
file_put_contents("data/created12.txt","no");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
تمامی محصولات رایگان حذف شدند 🌿
",
'parse_mode'=>'html',
'reply_markup' => $back2modiriyat ]);}
elseif($data == "delsabt12" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' => "
لیست محصولات رایگان فروشگاه به شرح زیر میباشد.

<pre>$listpro12</pre>

✅برای حذف محصول مورد نظر کافی است محصولی را که میخواهید حذف کنید را از لیست بالا پاک کنید و آن را بفرستید.

Ⓜ️برای مثال اگر لیست شما به صورت زیر بود:

سورس--123
مترجم--455
ویدیو--788

ℹ️برای حذف مترجم--455 کافی است آن را از لیست پاک کنید و لیست جدید که به شکل زیر است را ارسال کنید.

سورس--123
ویدیو--788

حتما باید هر کدام از محصولات در یک خط باشند . در این صورت مترجم--455 حذف میشود.
",
'parse_mode'=>'html',
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>'حذف ❌' , 'callback_data'=>"hafii12"]],
[['text'=>'برگشت ↩️' , 'callback_data'=>"2"]],
],
'resize_keyboard'=>true
])
]);
}
elseif($data == "hafii12" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","delli12");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"برای حذف کافی است مطابق مثال لیست جدید را بفرستید 📝",
'reply_markup' => $back2modiriyat ]);}
elseif($step == "delli12"){
file_put_contents("free/listpro12.txt","$text \n");
bot('Sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
محصولات جدید رایگان با لیست
  $text 
با موفقیت اضافه شدند✅
",
'reply_markup' => $back2modiriyat ]);}
elseif($data == "freepro13" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
به بخش محصول جدید رایگان خوش آمدید 🧩

💐 توجه کنید این محصول در بخش رایگان قرار میگیرد و دریافت آن برای عموم آزاد میباشد.

🚧 در این بخش از شما تعدادی اطلاعات گرفته خواهد شد لطفا به آن ها به دقت پاسخ دهید .

🚢 برای شروع بر روی دکمه زیر بزنید.
",
'parse_mode'=>'html',
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>'شروع 🍷' , 'callback_data'=>"startnewff"]],
[['text'=>'برگشت ↩️' , 'callback_data'=>"2"]],
],
'resize_keyboard'=>true
])
]);
}
elseif($data == "startnewff" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "proname12");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
📱 مرحله اول : 
📀 نام محصول را ارسال کنید!!!
",
'parse_mode'=>'html',
]);
}
elseif($step == "proname12"){
$rand12 = RandomString();
mkdir("free/$rand12");
file_put_contents("data/$chat_id/rand12.txt","$rand12");
file_put_contents("free/$rand12/proname12.txt","$text");
file_put_contents("data/$chat_id/step.txt","expro12");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
نام محصول $text ثبت شد ✅

💎مرحله دوم :
 توضیحاتی در مورد محصول مورد نظر ارسال کنید.
",
]);
}
elseif($step == "expro12"){
$rand12 = file_get_contents("data/$chat_id/rand12.txt");
file_put_contents("free/$rand12/expro12.txt","$text");
file_put_contents("data/$chat_id/step.txt","file12");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
توضیحات محصول ($text) ثبت شد ✅

⭕️ مرحله سوم : فایل هایی که قرار است با این محصول باشد را به صورت فایل (zip) شده بفرستید..

⚠️ حتما باید به صورت فایل Zip شده باشد .

🚸 درون فایل Zip هر فایلی که دارید میتونید قرار بدید..

🔰 حالا فایل Zip شده محصول را بفرستید..
",
]);
}
elseif($step == "file12"){
file_put_contents("data/$chat_id/step.txt","no");
$rand12 = file_get_contents("data/$chat_id/rand12.txt");
$document = $message->document;
$file12 = $document->file_id;
file_put_contents("free/$rand12/dlfile12.txt","$file12");
$dlfile12 = file_get_contents("free/$rand12/dlfile12.txt");
$proname12 = file_get_contents("free/$rand12/proname12.txt");
$expro12 = file_get_contents("free/$rand12/expro12.txt");
$listpro12 =  file_get_contents("free/listpro12.txt");
file_put_contents("data/created12.txt","ok");
$myfile12 = fopen("free/listpro12.txt", "a") or die("Unable to open file!");
fwrite($myfile12, "$proname12--$rand12 \n");
fclose($myfile12);
bot('senddocument',[
'chat_id'=>$admin,
'document'=>$dlfile12,
'caption'=>"
💠نام محصول : $proname12

📝 توضیحات : $expro12
",
]);
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
پیام بالا پیش نمایش محصول میباشد.

✅ محصول بالا رو فرستادم به بخش فروشگاه رایگان
",
'reply_markup' => $back2modiriyat ]);}
elseif($data == "delsabt" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
از منوی زیر انتخاب کنید 🌼
",
'parse_mode'=>'html',
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>'حذف ❌' , 'callback_data'=>"delsabt1"],['text'=>'حذف کلی محصولات 🪐' , 'callback_data'=>"hafiiall"]],
[['text'=>'برگشت ↩️' , 'callback_data'=>"2"]],
],
'resize_keyboard'=>true
])
]);
}
elseif($data == "hafiiall" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
unlink("pro/listpro.txt");
file_put_contents("data/created.txt","no");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
تمامی محصولات ویژه حذف شدند 🌿
",
'parse_mode'=>'html',
'reply_markup' => $back2modiriyat ]);}

elseif($data == "delsabt1" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
لیست محصولات فروشگاه به شرح زیر میباشد.

<pre>$listpro</pre>

✅برای حذف محصول مورد نظر کافی است محصولی را که میخواهید حذف کنید را از لیست بالا پاک کنید و آن را بفرستید.

Ⓜ️برای مثال اگر لیست شما به صورت زیر بود:

سورس-123
مترجم-455
ویدیو-788


ℹ️برای حذف مترجم-455 کافی است آن را از لیست پاک کنید و لیست جدید که به شکل زیر است را ارسال کنید.

سورس-123
ویدیو-788

حتما باید هر کدام از محصولات در یک خط باشند . در این صورت مترجم-455 حذف میشود.
",
'parse_mode'=>'html',
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>'حذف ❌' , 'callback_data'=>"hafii"]],
[['text'=>'برگشت ↩️' , 'callback_data'=>"2"]],
],
'resize_keyboard'=>true
])
]);
}
elseif($data == "hafii" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","delli");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"برای حذف کافی است مطابق مثال لیست جدید را بفرستید 📝",
'reply_markup' => $back2modiriyat ]);}
elseif($step == "delli"){
file_put_contents("pro/listpro.txt","$text \n");
bot('Sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
محصولات جدید با لیست
  $text 
با موفقیت اضافه شدند✅
",
'reply_markup' => $back2modiriyat ]);}
elseif($data == "sabtnew" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "none");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
به بخش محصول جدید خوش آمدید 🧩

🚧 در این بخش از شما تعدادی اطلاعات گرفته خواهد شد لطفا به آن ها به دقت پاسخ دهید .

🚢 برای شروع بر روی دکمه زیر بزنید.
",
'parse_mode'=>'html',
'reply_markup'=>json_encode([
'inline_keyboard'=>[
[['text'=>'شروع 🏭' , 'callback_data'=>"startnew"]],
[['text'=>'برگشت ↩️' , 'callback_data'=>"2"]],
],
'resize_keyboard'=>true
])
]);
}
elseif($data == "startnew" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt", "proname");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"
📱 مرحله اول : 
📀 نام محصول را ارسال کنید!!!
",
'parse_mode'=>'html',
]);
}
elseif($step == "proname"){
$rand = RandomString();
mkdir("pro/$rand");
file_put_contents("data/$chat_id/rand.txt","$rand");
file_put_contents("pro/$rand/proname.txt","$text");
file_put_contents("data/$chat_id/step.txt","expro");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
نام محصول $text ثبت شد ✅

💎مرحله دوم :
 توضیحاتی در مورد محصول مورد نظر ارسال کنید.
",
]);
}
elseif($step == "expro"){
$rand = file_get_contents("data/$chat_id/rand.txt");
file_put_contents("pro/$rand/expro.txt","$text");
file_put_contents("data/$chat_id/step.txt","polpro");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
توضیحات محصول ($text) ثبت شد ✅

🦋 مرحله سوم : قیمت محصول را وارد کنید .
به تومان🎩
مثال:
5000
",
]);
}
elseif($step == "polpro"){
$rand = file_get_contents("data/$chat_id/rand.txt");
file_put_contents("pro/$rand/polpro.txt","$text");
file_put_contents("data/$chat_id/step.txt","sekpro");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
قیمت محصول ($text هزار تومان) ثبت شد ✅

🔰مرحله چهارم : تعداد سکه لازم(به عدد لاتین) برای دریافت محصول را وارد کنید.
",
]);
}
elseif($step == "sekpro"){
$rand = file_get_contents("data/$chat_id/rand.txt");
file_put_contents("pro/$rand/sekpro.txt","$text");
file_put_contents("data/$chat_id/step.txt","file");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
تعدا سکه برای دریافت ($text) ثبت شد✅

⭕️ مرحله پنجم : فایل هایی که قرار است با این محصول باشد را به صورت فایل (zip) شده بفرستید..

⚠️ حتما باید به صورت فایل Zip شده باشد .

🚸 درون فایل Zip هر فایلی که دارید میتونید قرار بدید..

🔰 حالا فایل Zip شده محصول را بفرستید..
",
]);
}
elseif($step == "file"){
file_put_contents("data/$chat_id/step.txt","no");
$rand = file_get_contents("data/$chat_id/rand.txt");
$document = $message->document;
$file = $document->file_id;
file_put_contents("pro/$rand/dlfile.txt","$file");
$dlfile = file_get_contents("pro/$rand/dlfile.txt");
$proname = file_get_contents("pro/$rand/proname.txt");
$expro = file_get_contents("pro/$rand/expro.txt");
$sekpro = file_get_contents("pro/$rand/sekpro.txt");
$polpro = file_get_contents("pro/$rand/polpro.txt");
file_put_contents("data/created.txt","ok");
$listpro =  file_get_contents("pro/listpro.txt");
$myfile1 = fopen("pro/listpro.txt", "a") or die("Unable to open file!");
fwrite($myfile1, "$proname-$rand \n");
fclose($myfile1);
bot('senddocument',[
'chat_id'=>$admin,
'document'=>$dlfile,
'caption'=>"
💠نام محصول : $proname

📝 توضیحات : $expro

📤 سکه لازم برای دریافت : $sekpro

💰قیمت محصول : $polpro تومان

🧾 کد محصول : $rand

🎗کانال ما :
🆔 @$channel
",
]);
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
پیام بالا پیش نمایش محصول میباشد.

✅ محصول بالا رو فرستادم به بخش فروشگاه رایگان
",
'reply_markup' => $back2modiriyat ]);}
//===========//
elseif($data == "idmodir"  && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","texto");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"ایدی ارتباط با مدیر را بدون @ ارسال کنید.",
'reply_markup' => $back2modiriyat ]);}
elseif($step == "texto"){
file_put_contents("data/mid.txt",$text);
file_put_contents("data/$chat_id/step.txt","no");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"تنظیم شد.",
'reply_markup' => $back2modiriyat ]);}

elseif($data == "textsek"  && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","textok");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"متن فروش سکه را ارسال کنید.",
'reply_markup' => $back2modiriyat ]);}
elseif($step == "textok"){
file_put_contents("data/buytext.txt",$text);
file_put_contents("data/$chat_id/step.txt","no");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"تنظیم شد.",
'reply_markup' => $back2modiriyat ]);}
//==========//
elseif($data == "off" && $chatid == $admin){
if($on != "off"){
file_put_contents("data/on.txt","off");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"🎭 ربات خاموش شد",
'parse_mode'=>'html',
'reply_markup' => $back2modiriyat ]);}else{
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text' =>"ربات از قبل خاموش بود...",
'parse_mode'=>'html',
'reply_markup' => $back2modiriyat ]);}
}
//========//
elseif($data == "unblock" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","sharr");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"لطفا ایدی عددی کاربر مورد نظر رو ارسال کنید",
'reply_markup' => $back2modiriyat ]);}
elseif($step == "sharr"){
file_put_contents("data/$chat_id/step.txt", "none");
$newlist = str_replace($text, "", $blocklist);
file_put_contents("data/blocklist.txt", $newlist);
bot('Sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
خب ایدی $text از بلاکی درآمد 😎
",
'reply_markup' => $back2modiriyat ]);
bot('Sendmessage',[
'chat_id'=>$text,
'text'=>"
ارتباط شما با سرور برقرار شد و میتوانید از بات استفاده کنید 😻
",
]);
}
//===
elseif($data == "block" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","shar");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"لطفا ایدی فرد مورد نظر را ارسال کنید",
'reply_markup' => $back2modiriyat ]);}
elseif($step == "shar"){
file_put_contents("data/$chat_id/step.txt", "none");
file_put_contents("data/$from_id/shar.txt","$text");
bot('Sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
ایدی $text از ربات بلاک شد
",
'reply_markup' => $back2modiriyat ]);
$adduser = file_get_contents("data/blocklist.txt");
$adduser .= $text . "\n";
file_put_contents("data/blocklist.txt", $adduser);
$id11 = file_get_contents("data/$from_id/shar.txt");
bot('Sendmessage',[
'chat_id'=>$id11,
'text'=>"ارتباط شما با سرور ما قطع شد و نمیتوانید از بات استفاده کنید 😹",
]);
}
//===========//
elseif($data == 'scoreall' && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","scoreall");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"تعداد سکه همگانی را وارد کنید",
'reply_markup' => $back2modiriyat ]);}

elseif($step == "scoreall"){
$mem = file_get_contents("data/users.txt");
$Member = explode("\n",$mem);
$count = count($Member)-2;
for($z = 0;$z <= $count;$z++){
$user = $Member[$z];
$cn = file_get_contents("data/$user/coin.txt");
$newham = $cn+$text ;
file_put_contents("data/$user/coin.txt",$newham);
file_put_contents("data/$chat_id/step.txt","no");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"تعداد $text سکه همگانی به کاربران ارسال شد",
'reply_markup' => $back2modiriyat ]);
bot('sendmessage',[
'chat_id'=>$user,
'text'=>"
#سکه_همگانی
☑️از طرف مدیر تعداد $text سکه به حساب شما افزوده شد.
",
]);
}
}
//==========//
elseif($data == "sefr" && $chatid ==$admin){
file_put_contents("data/$chatid/step.txt","em0");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"👩‍💻 لطفا آیدی عددی کاربری که میخواهید تعداد امتیازات او را 0 را ارسال کنید :",
'reply_markup' => $back2modiriyat ]);}
elseif($step == "em0"){
file_put_contents("data/$chat_id/step.txt","none");
$aad = file_get_contents("data/$text/coin.txt");
file_put_contents("data/$text/coin.txt","0");
bot('Sendmessage',[
'chat_id'=>$chat_id,
'text'=>"
🔪 امتیاز های او صفر شد
",
'reply_markup' => $back2modiriyat ]);
bot('Sendmessage',[
'chat_id'=>$text,
'text'=>"🔥امتیازات شما به دلیل آوردن زیرمجموعه فیک حذف شدند!",
]);
}
//==========//
elseif($data== "score" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","fromidforcoin");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"لطفا ایدی فرد مورد نظر را ارسال کنید",
'reply_markup' => $back2modiriyat ]);}
elseif($step == "fromidforcoin"){
file_put_contents("data/$chat_id/step.txt","tedadecoin4set");
file_put_contents("data/$from_id/to.txt",$text);
$coin = file_get_contents("data/$text/coin.txt");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text' =>"
💰تعداد سکه کاربر : $coin
💡چند سکه به کاربر ارسال کنم ؟
",
]);
}
elseif($step == "tedadecoin4set"){
file_put_contents("data/$chat_id/step.txt","none");
$coin = file_get_contents("data/$to/coin.txt");
settype($coin,"integer");
$newcoin = $coin + $text;
file_put_contents("data/$to/coin.txt",$newcoin);
$cooin = $coin + $text;
bot('sendmessage', [
'chat_id' => $admin,
'text' =>"
تعداد $text سکه افزوده شد 🔋
💎تعداد کل سکه کاربر : $cooin
",
'reply_markup' => $back2modiriyat ]);
bot('sendmessage',[
'chat_id' => $to,
'text' =>"
تعداد $text سکه به حساب شما افزوده شد ✅
تعداد کل سکه شما 💰 : $cooin
",
]);
}
//===========//
elseif($data == 'forall' && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","fortoall");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"لطفا متن خود را فوروارد کنید 🚀",
'reply_markup' => $back2modiriyat ]);}
elseif($step == 'fortoall' ){
file_put_contents("data/$chat_id/step.txt","no");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"پیام با موفقیت ارسال شد✔️",
'reply_markup' => $back2modiriyat ]);
$mem = fopen( "data/users.txt", 'r');
while(!feof($mem)){
$memuser = fgets($mem);
Forward($memuser, $chat_id,$message_id);
}
}

elseif($data == "pmall" && $chatid == $admin){
file_put_contents("data/$chatid/step.txt","pmh");
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"پیام خود را ارسال کنید",
'parse_mode'=>'html',
'reply_markup' => $back2modiriyat ]);}
elseif($step == "pmh" ){
file_put_contents("data/$chat_id/step.txt","none");
bot('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"پیام شما فرستاده شد 💫",
'reply_markup' => $back2modiriyat ]);
$all_member = fopen( "data/users.txt", "r");
while( !feof( $all_member)){
$user = fgets( $all_member);
SendMessage($user,$text,"html");
}
}
//==========//
elseif($data == "amar" && $chatid == $admin){
$user = file_get_contents("data/users.txt");
$member_id = explode("\n",$user);
$member_count = count($member_id) -1;
bot('editMessagetext',[
'chat_id'=>$chatid,
'message_id'=>$messageid,
'text'=>"
🎩 Amar ::: $member_count
",
'parse_mode'=>'html',
'reply_markup' => $back2modiriyat ]);}
// پردازش درخواست اخبار و ارسال به تلگرام در دکمه‌های شیشه‌ای
elseif($data == "latest_news") {
    $newsArticles = getNewsFromNewsAPI();

    if (!$newsArticles) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ خطا در دریافت اخبار. لطفاً بعداً تلاش کنید.",
        ]);
        exit;
    }

    $message = "📰 *آخرین اخبار اقتصادی:*\n\n";

    foreach ($newsArticles as $index => $article) {
        $title = $article['title'];
        $url = $article['url'];
        $publishedAt = $article['publishedAt'];
        $formattedDate = date("Y-m-d H:i", strtotime($publishedAt));
        $importance = getNewsImportance($title, $publishedAt); // تعیین اهمیت خبر

        $message .= "📌 *خبر " . ($index + 1) . ":*\n";
        $message .= "$importance\n"; // نمایش اهمیت خبر
        $message .= "🗞 *عنوان:* $title\n";
        $message .= "📅 *زمان انتشار:* $formattedDate\n";
        $message .= "🔗 [مشاهده خبر]($url)\n\n";
    }

    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => $message,
        'parse_mode' => 'Markdown',
        'disable_web_page_preview' => false
    ]);
    $keyboard = [
        [['text' => "🔄 بروزرسانی", 'callback_data' => "latest_news"]],
        [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
    ];

    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => $message,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}
if ($data == "crypto_update") {
    $prices = getCryptoPrices($cryptoList); // دریافت قیمت ۲۰ ارز برتر

    $message = "📊 آخرین وضعیت ۲۰ ارز برتر بازار کریپتو:\n\n";
    foreach ($prices as $name => $info) {
        $price = $info['price'];
        $change = $info['change'];
        $changeSymbol = $change >= 0 ? "📈" : "📉"; // نمایش آیکون تغییرات مثبت یا منفی

        $message .= "🔹 $name:\n💲 قیمت: \$$price\n$changeSymbol تغییر ۲۴ساعته: {$change}%\n\n";
    }

    $keyboard = [
        [['text' => "🔄 بروزرسانی", 'callback_data' => "crypto_update"]],
        [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
    ];

    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => $message,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}
// پردازش کلیک روی "تحلیل"
elseif ($data == "market_analysis") {
    file_put_contents("data/$chatid/state.txt", "none");
    bot('editMessagetext', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "لطفا یکی از گزینه‌های زیر را انتخاب کنید:",
        'parse_mode' => "html",
        'reply_markup' => $market_analysis_menu
    ]);
}

// پردازش کلیک روی "تحلیل بازار کریپتو"
elseif ($data == "c_anal") {
    bot('editMessagetext', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⏳ لطفا تایم فریم خود را انتخاب کنید:",
        'parse_mode' => "html",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "5 دقیقه", 'callback_data' => "timeframe_5m"]],
                [['text' => "15 دقیقه", 'callback_data' => "timeframe_15m"]],
                [['text' => "30 دقیقه", 'callback_data' => "timeframe_30m"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
// پردازش کلیک روی "تحلیل بازار فارکس"
elseif ($data == "forex_analysis") {
    // کد مربوط به تحلیل بازار فارکس
    bot('editMessagetext', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "تحلیل بازار فارکس در حال انجام است...",
        'parse_mode' => "html",
        'reply_markup' => $market_analysis_menu
    ]);
}
elseif ($data == "activate_button") {
    $users = file("data/users.txt", FILE_IGNORE_NEW_LINES); // خواندن فایل users.txt

    if (!empty($users)) {
        $keyboard = [];
        foreach ($users as $user_id) {
            $keyboard[] = [['text' => "👤 کاربر $user_id", 'callback_data' => "activate_user_$user_id"]];
        }
        $keyboard[] = [['text' => "بازگشت ↩️", 'callback_data' => "back"]];

        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "👥 لیست کاربران:\n\nلطفا کاربر مورد نظر را انتخاب کنید:",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    } else {
        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "❌ هیچ کاربری در سیستم وجود ندارد!",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
                ]
            ])
        ]);
    }
}
elseif (strpos($data, "activate_user_") !== false) {
    $target_user_id = str_replace("activate_user_", "", $data); // استخراج ایدی کاربر

    // فعال‌سازی دکمه برای کاربر
    file_put_contents("data/$target_user_id/button_active.txt", "true");

    bot('editMessagetext', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✅ دکمه برای کاربر با ایدی $target_user_id فعال شد.",
        'parse_mode' => "html",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif ($data == "deactivate_button") {
    $users = file("data/users.txt", FILE_IGNORE_NEW_LINES); // خواندن فایل users.txt

    if (!empty($users)) {
        $keyboard = [];
        foreach ($users as $user_id) {
            $keyboard[] = [['text' => "👤 کاربر $user_id", 'callback_data' => "deactivate_user_$user_id"]];
        }
        $keyboard[] = [['text' => "بازگشت ↩️", 'callback_data' => "back"]];

        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "👥 لیست کاربران:\n\nلطفا کاربر مورد نظر را انتخاب کنید:",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    } else {
        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "❌ هیچ کاربری در سیستم وجود ندارد!",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
                ]
            ])
        ]);
    }
}
elseif (strpos($data, "deactivate_user_") !== false) {
    $target_user_id = str_replace("deactivate_user_", "", $data); // استخراج ایدی کاربر

    file_put_contents("data/$chatid/button_deactive.txt", "false");   
 
    bot('editMessagetext', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✅ دکمه برای کد $target_user_id فعال شد.",
        'parse_mode' => "html",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif ($data == "special_button") {
    // بررسی وجود فایل و خواندن وضعیت دکمه
    if ($kelid == "BQACAgQAAxkBAAIJrWe3F7pHC_xZydVRMEUW41qqlDrjAAJHFQAC6ya4UYyretLuXGDkNgQ") {
        // اگر دکمه فعال باشد، منوی انتخاب تایم فریم نمایش داده می‌شود
        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "در اینجا شما می توانید از امکانات فوق العاده ربات سمفونی پروفیت استفاده کنید ❤️",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                     [['text' => "هوش مصنوعی 🤖", 'callback_data' => "ai_analysis"]],
                    [['text'=>"آنالیز بازار 📈", 'callback_data'=>"market_analysis"],
['text'=>" آخرین اخبار اقتصادی 📰", 'callback_data'=>"latest_news"]],
[['text' => "نمایش چارت 📊", 'callback_data' => "show_chart"],
['text' => "🕒 زمان بازار فارکس️", 'callback_data' => "forex_time"]],
[['text' => "هشدار های من 〽️", 'callback_data' => "my_alerts"], // دکمه جدید
['text'=>"تنظیم هشدار ⚠️", 'callback_data'=>"set_alert"]],
[['text' => "📸 اسکرین‌شات سایت", 'callback_data' => "take_screenshot"],
['text' => "📈 اطلاعات بازار", 'callback_data' => "market_stats"]],
[['text' => "نرخ ارزها 💱", 'callback_data' => "currency_rates"]],
[['text' => "شاخص ترس و طمع 💀", 'callback_data' => "fear_greed_index"],
['text' => "رفتار سرمایه گذاران 👨‍💻", 'callback_data' => "investor_analysis"]],
[['text' => "💡 آخرین ایده‌ها", 'callback_data' => "latest_ideas"],
['text'=>"آخرین تغیرات کریپتو 📊", 'callback_data'=>"crypto_update"]]
                ]
            ])
        ]);
    } else {
        // اگر دکمه فعال نباشد، پیام خطا نمایش داده می‌شود
        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "❌ برای استفاده از ابزار های ربات سمفونی پروفیت شما نیاز به تهیه اشتراک دارید !
سپس شما باید قوانین و حریم خصوصی را تایید کنید ❌",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
                ]
            ])
        ]);
    }
}
if ($data == "forex_time") {
    // تعریف پارامترهای زمانی بدون تغییر منطقه زمانی اصلی
    $utcTime = new DateTime('now', new DateTimeZone('UTC'));
    $tehranTime = clone $utcTime;
    $tehranTime->setTimezone(new DateTimeZone('Asia/Tehran'));

    // تعریف بازارها با بازه زمانی UTC
    $markets = [
        'WELLINGTON(NZX)'      => ['open' => 21, 'close' => 5],
        '(CME)(NYMEX)'  => ['open' => 22, 'close' => 23],
        'SYDNEY(ASX)'     => ['open' => 23, 'close' => 5],
        'TOKYO(JPX)(TSE)'     => ['open' => 0, 'close' => 6],
        'SINGAPORE(SGX)'  => ['open' => 1, 'close' => 9],
        'LONDON METAL(LME)'      => ['open' => 1, 'close' => 19],
        'HONG KONG(HKEX)'  => ['open' => 2, 'close' => 8],
        'SHANGHAI(SSE)'   => ['open' => 2, 'close' => 7],
        'MUMBAI(NSE)(BSE)'     => ['open' => 4, 'close' => 10],
        'DUBAI(DFM)'     => ['open' => 6, 'close' => 10],
        'JOHANNESBURG(JSE)'     => ['open' => 7, 'close' => 15],
        'MOSCOW(MOEX)'     => ['open' => 7, 'close' => 15],
        'RIYADH(TADAWUL)'     => ['open' => 7, 'close' => 12],
        'FRANKFURT(XETRA)' => ['open' => 7, 'close' => 15],
        'DIAMOND(AWDC)'        => ['open' => 8, 'close' => 15],
        'PARIS(EURONEXT)'  => ['open' => 8, 'close' => 16],
        'LONDON(LSE)(LBMA)'      => ['open' => 8, 'close' => 16],
        'ZURICH(SIX)'      => ['open' => 8, 'close' => 16],
        'FRANKFURT(FWB)' => ['open' => 8, 'close' => 16],
        'SAO PAULO(BM)(BOVESPA)' => ['open' => 13, 'close' => 20],
        'NEW YORK(NYSE)(NASDAQ)' => ['open' => 14, 'close' => 20],
        'TORENTO(TSX)'    => ['open' => 14, 'close' => 20],
        'CHICAGO(NYSE)' => ['open' => 14, 'close' => 20],
    ];

    $response = "⏰ *زمان بازارهای فارکس (UTC)*\n\n";
    
    foreach ($markets as $name => $times) {
        $openTime = (new DateTime())->setTime($times['open'], 0)->setTimezone(new DateTimeZone('UTC'));
        $closeTime = (new DateTime())->setTime($times['close'], 0)->setTimezone(new DateTimeZone('UTC'));
        
        // تطابق بازه زمانی برای بازارهای بین روزی
        if ($times['open'] > $times['close']) {
            $closeTime->modify('+1 day');
        }

        // بررسی وضعیت بازار
        $isOpen = ($utcTime >= $openTime && $utcTime < $closeTime);
        $status = $isOpen ? "✅" : "❌";
        
        $response .= sprintf(
            "%s: %02d:00 - %02d:00 UTC • %s\n",
            $name,
            $times['open'],
            $times['close'],
            $status
        );
    }

    // افزودن زمانهای فعلی
    $response .= "\n🕒 زمان فعلی:\n";
    $response .= "▫️ UTC: " . $utcTime->format('H:i') . "\n";
    $response .= "▫️ TEHRAN: " . $tehranTime->format('H:i');

    // ارسال پاسخ
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => $response,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode(['inline_keyboard' => [[
            ['text' => '🔄 بروزرسانی', 'callback_data' => 'forex_time'],
            ['text' => '🔙 بازگشت', 'callback_data' => 'special_button']
        ]]])
    ]);
}
elseif (strpos($data, "timeframe_") !== false) {
    $timeframe = str_replace("timeframe_", "", $data); // استخراج تایم فریم (مثلاً 5m)
    file_put_contents("data/$chatid/timeframe.txt", $timeframe); // ذخیره تایم فریم

    // نمایش منوی عمق بازار
    bot('editMessagetext', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 لطفا عمق بازار (تعداد کندل‌ها) را انتخاب کنید:",
        'parse_mode' => "html",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "10 کندل", 'callback_data' => "limit_10"]],
                [['text' => "50 کندل", 'callback_data' => "limit_50"]],
                [['text' => "100 کندل", 'callback_data' => "limit_100"]],
                [['text' => "250 کندل", 'callback_data' => "limit_250"]],
                [['text' => "500 کندل", 'callback_data' => "limit_500"]],
                [['text' => "1000 کندل", 'callback_data' => "limit_1000"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif (strpos($data, "limit_") !== false) {
    $limit = str_replace("limit_", "", $data); // استخراج تعداد کندل‌ها (مثلاً 100)
    file_put_contents("data/$chatid/limit.txt", $limit); // ذخیره تعداد کندل‌ها

    // نمایش لیست رمز ارزها
    bot('editMessagetext', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "🔍 لطفا ارز مورد نظر خود را انتخاب کنید :",
        'parse_mode' => "html",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "Bitcoin (BTC)", 'callback_data' => "crypto_BTCUSDT"],
                ['text' => "Ethereum (ETH)", 'callback_data' => "crypto_ETHUSDT"]],
                [['text' => "Binance Coin (BNB)", 'callback_data' => "crypto_BNBUSDT"],
                ['text' => "Ripple (XRP)", 'callback_data' => "crypto_XRPUSDT"]],
                [['text' => "Cardano (ADA)", 'callback_data' => "crypto_ADAUSDT"],
                ['text' => "Dogecoin (DOGE)", 'callback_data' => "crypto_DOGEUSDT"]],
                [['text' => "Solana (SOL)", 'callback_data' => "crypto_SOLUSDT"],
                ['text' => "Polkadot (DOT)", 'callback_data' => "crypto_DOTUSDT"]],
                [['text' => "Litecoin (LTC)", 'callback_data' => "crypto_LTCUSDT"],
                ['text' => "Chainlink (LINK)", 'callback_data' => "crypto_LINKUSDT"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif (strpos($data, "crypto_") !== false) {
    $symbol = str_replace("crypto_", "", $data); // استخراج نماد رمز ارز (مثلاً BTCUSDT)
    $timeframe = file_get_contents("data/$chatid/timeframe.txt"); // خواندن تایم فریم ذخیره شده
    $limit = file_get_contents("data/$chatid/limit.txt"); // خواندن تعداد کندل‌ها

    // دریافت داده‌ها از API بایننس
    $url = "https://api.binance.com/api/v3/klines?symbol=$symbol&interval=$timeframe&limit=$limit";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);

    if ($data && !isset($data['code'])) {
        $last_candle = end($data); // آخرین کندل

        // استخراج اطلاعات کندل
        $open_time = $last_candle[0]; // زمان باز شدن کندل (میلی‌ثانیه)
        $open_price = $last_candle[1]; // قیمت باز شدن
        $high_price = $last_candle[2]; // بالاترین قیمت
        $low_price = $last_candle[3]; // پایین‌ترین قیمت
        $close_price = $last_candle[4]; // قیمت بسته شدن
        $volume = $last_candle[5]; // حجم معاملات
        $close_time = $last_candle[6]; // زمان بسته شدن کندل (میلی‌ثانیه)
        $quote_asset_volume = $last_candle[7]; // حجم معاملات کوین پایه (مثلاً USDT)
        $number_of_trades = $last_candle[8]; // تعداد معاملات
        $taker_buy_base_asset_volume = $last_candle[9]; // حجم خرید برحسب کوین پایه
        $taker_buy_quote_asset_volume = $last_candle[10]; // حجم خرید برحسب کوین پایه
        $ignore = $last_candle[11]; // Ignore (معمولاً نادیده گرفته می‌شود)

        // تبدیل زمان به فرمت خوانا
        $open_time_readable = date("Y-m-d H:i:s", $open_time / 1000);
        $close_time_readable = date("Y-m-d H:i:s", $close_time / 1000);

        // تحلیل سیگنال
        $riskFactor = 0.001; // 0.1% ریسک
        $signal = ($close_price > $open_price) ? "🟢 سیگنال خرید" : "🔴 سیگنال فروش";
 // محاسبه سیگنال خرید (Buy Signal)
        $buyEntryPrice = $close_price;
        $buyStopLoss = $buyEntryPrice - ($buyEntryPrice * $riskFactor);
        $buyTakeProfit_3 = $buyEntryPrice + 3 * ($buyEntryPrice - $buyStopLoss);
        $buyTakeProfit_5 = $buyEntryPrice + 5 * ($buyEntryPrice - $buyStopLoss);

    // محاسبه سیگنال فروش (Sell Signal)
        $sellEntryPrice = $close_price;
        $sellStopLoss = $sellEntryPrice + ($sellEntryPrice * $riskFactor);
        $sellTakeProfit_3 = $sellEntryPrice - 3 * ($sellStopLoss - $sellEntryPrice);
        $sellTakeProfit_5 = $sellEntryPrice - 5 * ($sellStopLoss - $sellEntryPrice);
        // نمایش نتیجه
        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "📈 تحلیل برای $symbol ($timeframe) با $limit کندل:\n\n"
                . "⏰ زمان باز شدن کندل: $open_time_readable\n"
                . "💰 قیمت باز شدن: $open_price\n"
                . "📈 بالاترین قیمت: $high_price\n"
                . "📉 پایین‌ترین قیمت: $low_price\n"
                . "💰 قیمت بسته شدن: $close_price\n"
                . "📊 حجم معاملات: $volume\n"
                . "⏰ زمان بسته شدن کندل: $close_time_readable\n"
                . "💵 حجم معاملات کوین پایه: $quote_asset_volume\n"
                . "🔢 تعداد معاملات: $number_of_trades\n"
                . "🛒 حجم خرید برحسب کوین پایه: $taker_buy_base_asset_volume\n"
                . "🛒 حجم خرید برحسب کوین پایه: $taker_buy_quote_asset_volume\n"
                . "🚫 در نظر گرفته نشده: $ignore\n\n"
                . "🔵 سیگنال خرید (Buy Signal)\n"
                . "💰 قیمت ورود: \$$buyEntryPrice\n"
                . "🛑 حد ضرر: \$$buyStopLoss\n"
                . "🎯 حد سود (1:3): \$$buyTakeProfit_3\n"
                . "🎯 حد سود (1:5): \$$buyTakeProfit_5\n\n"
                . "🔴 سیگنال فروش (Sell Signal)\n"
                . "💰 قیمت ورود: \$$sellEntryPrice\n"
                . "🛑 حد ضرر: \$$sellStopLoss\n"
                . "🎯 حد سود (1:3): \$$sellTakeProfit_3\n"
                . "🎯 حد سود (1:5): \$$sellTakeProfit_5\n"

                . "📢 @signalica",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
                ]
            ])
        ]);
    } else {
        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "❌ خطا در دریافت داده‌ها از بایننس!",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
                ]
            ])
        ]);
    }
}
elseif ($data == "show_rules") {
    showRules($chatid, $messageid);
}

elseif ($data == "accept_rules") {
    // استفاده از $chatid به‌جای $from_id برای تعیین مسیر صحیح ذخیره فایل
    file_put_contents("data/$chatid/rules_accepted.txt", "yes");

    bot('answerCallbackQuery', [
        'callback_query_id' => $callback_query_id,
        'text' => "✅ قوانین با موفقیت پذیرفته شد!",
        'show_alert' => true
    ]);

    // بازگشت به منوی اصلی
    bot('deleteMessage', [
        'chat_id' => $chatid,
        'message_id' => $messageid
    ]);
}
elseif ($data == "ai_analysis") {
    $rulesAccepted = file_get_contents("data/$chatid/rules_accepted.txt");

    if ($rulesAccepted == "yes") {
        bot('editMessagetext', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "🤖 گزینه‌های هوش مصنوعی:\nلطفا یکی از ابزارها را انتخاب کنید:",
            'parse_mode' => "html",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "هوش مصنوعی اندیکاتور 🔫", 'callback_data' => "ai_advanced_analysis"]],
                    [['text' => "هوش مصنوعی هارمونیک 🧨", 'callback_data' => "ai_2"]],
                    [['text' => "هوش مصنوعی زنده 💣", 'callback_data' => "ai_3"]],
                    [['text' => "هوش مصنوعی #۴", 'callback_data' => "ai_4"]],
                    [['text' => "هوش مصنوعی #۵", 'callback_data' => "ai_5"]],
                    [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
                ]
            ])
        ]);
    } else {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "⚠️ برای استفاده از هوش مصنوعی، ابتدا باید قوانین را بپذیرید.",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => '📜 پذیرش قوانین', 'callback_data' => 'show_rules']],
                    [['text' => '🔙 بازگشت به منو', 'callback_data' => 'back']]
                ]
            ])
        ]);
    }
}
elseif($data == "entry_point") {
    bot('editMessagetext', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "لطفاً یکی از گزینه‌های زیر را انتخاب کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "کریپتو 💹", 'callback_data' => "crypto"]],
                [['text' => "فارکس 📈", 'callback_data' => "forex"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif($data == "show_chart"){
    bot('editMessagetext',[
        'chat_id'=>$chatid,
        'message_id'=>$messageid,
        'text'=>"📊 لطفا یکی از ارزهای دیجیتال زیر را انتخاب کنید:",
        'reply_markup'=>json_encode([
            'inline_keyboard'=>[
                [['text'=>"Bitcoin (BTC)", 'callback_data'=>"chart_BTCUSDT"]],
                [['text'=>"Ethereum (ETH)", 'callback_data'=>"chart_ETHUSDT"]],
                [['text'=>"Binance Coin (BNB)", 'callback_data'=>"chart_BNBUSDT"]],
                [['text'=>"بازگشت ↩️", 'callback_data'=>"back"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "chart_") === 0){
    $symbol = str_replace("chart_", "", $data);
    
    bot('editMessagetext',[
        'chat_id'=>$chatid,
        'message_id'=>$messageid,
        'text'=>"⏳ لطفا تایم فریم مورد نظر خود را انتخاب کنید:",
        'reply_markup'=>json_encode([
            'inline_keyboard'=>[
                [['text'=>"5m", 'callback_data'=>"timframe_{$symbol}_5m"]],
                [['text'=>"15m", 'callback_data'=>"timframe_{$symbol}_15m"]],
                [['text'=>"30m", 'callback_data'=>"timframe_{$symbol}_30m"]],
                [['text'=>"1h", 'callback_data'=>"timframe_{$symbol}_1h"]],
                [['text'=>"بازگشت ↩️", 'callback_data'=>"back"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "timframe_") === 0){
    $parts = explode("_", $data);
    $symbol = $parts[1];
    $interval = $parts[2];

    // دریافت داده‌های چارت از بایننس با تایم فریم انتخاب‌شده
    $chartData = getBinanceChartData($symbol, $interval);
            
    if (!$chartData) {
        bot('sendMessage',[
            'chat_id'=>$chatid,
            'text'=>"❌ خطا در دریافت اطلاعات چارت!",
        ]);
        exit;
    }

    $width = 1920;
    $height = 1080;
    $image = imagecreatetruecolor($width, $height);
    imageantialias($image, true); // فعال کردن آنتی‌الیاسینگ
    $background = imagecolorallocate($image, 255, 255, 255);
    imagefill($image, 0, 0, $background);

    // رنگ‌ها
    $black = imagecolorallocate($image, 0, 0, 0);
    $green = imagecolorallocate($image, 0, 200, 0);
    $red = imagecolorallocate($image, 200, 0, 0);
    $blue = imagecolorallocate($image, 0, 0, 255); // رنگ SMA
    $watermarkColor = imagecolorallocate($image, 150, 150, 150);
    imagesetthickness($image, 2); // ضخامت بیشتر برای خطوط کندل‌ها

    // محاسبه مقیاس چارت
    $minPrice = min(array_column($chartData, 3)); // کمترین قیمت (low)
    $maxPrice = max(array_column($chartData, 2)); // بیشترین قیمت (high)
    $priceRange = $maxPrice - $minPrice;

    if ($priceRange == 0) {
        $priceRange = 1; // جلوگیری از تقسیم بر صفر
    }

    $scale = ($height - 40) / $priceRange; // مقیاس ارتفاع

    // محاسبه SMA
    $smaValues = calculateSMA($chartData, 10);

    $x = 40;
    $prevSMAx = null;
    $prevSMAy = null;
    
    foreach ($chartData as $index => $candle) {
        $open = $candle[1];
        $high = $candle[2];
        $low = $candle[3];
        $close = $candle[4];

        $yHigh = $height - (($high - $minPrice) * $scale) - 20;
        $yLow = $height - (($low - $minPrice) * $scale) - 20;
        $yOpen = $height - (($open - $minPrice) * $scale) - 20;
        $yClose = $height - (($close - $minPrice) * $scale) - 20;

        $color = ($close >= $open) ? $green : $red;

        // رسم کندل‌ها
        imageline($image, $x, $yHigh, $x, $yLow, $black);
        imagefilledrectangle($image, $x - 3, min($yOpen, $yClose), $x + 3, max($yOpen, $yClose), $color);

        // رسم SMA
        if ($smaValues[$index] !== null) {
            $smaY = $height - (($smaValues[$index] - $minPrice) * $scale) - 20;
            if ($prevSMAx !== null) {
                imageline($image, $prevSMAx, $prevSMAy, $x, $smaY, $blue);
            }
            $prevSMAx = $x;
            $prevSMAy = $smaY;
        }

     
        // ✅ نمایش قیمت‌های High و Low
        imagestring($image, 2, $x + 5, $yHigh - 12, round($high, 2), $black); // قیمت High کنار سایه بالایی
        imagestring($image, 2, $x + 5, $yLow + 5, round($low, 2), $black); // قیمت Low کنار سایه پایینی

        $x += 12; // فاصله هر کندل
    }

    // نمایش حداقل و حداکثر قیمت
    imagestring($image, 3, 5, $height - 40, "Min: " . round($minPrice, 2), $black);
    imagestring($image, 3, 5, 5, "Max: " . round($maxPrice, 2), $black);
    imagestring($image, 5, $width - 200, $height - 30, "@SIGNALICA", $watermarkColor);
    
    // ذخیره و ارسال تصویر
    $imagePath = "chart_$symbol.jpeg";
    imagejpeg($image, $imagePath, 90); // ذخیره تصویر با کیفیت 90%
    imagedestroy($image);

    bot('sendPhoto',[
        'chat_id'=>$chatid,
        'photo'=>new CURLFile($imagePath),
'caption'=>"📈 چارت قیمت $symbol $interval \n🔹 اندیکاتور SMA (10) اضافه شد.\n🔹 قیمت‌های ، High، Low نمایش داده شدند."    ]);

    unlink($imagePath); // حذف فایل بعد از ارسال
}
elseif($data == "fear_greed_index"){
    $url = "https://api.alternative.me/fng/?limit=10";
    $response = file_get_contents($url);
    if (!$response) {
        bot('sendMessage',[
            'chat_id'=>$chatid,
            'text'=>"❌ خطا در دریافت شاخص ترس و طمع!",
        ]);
        exit;
    }

    $indexData = json_decode($response, true);
    if (!isset($indexData['data']) || count($indexData['data']) < 7) {
        bot('sendMessage',[
            'chat_id'=>$chatid,
            'text'=>"❌ اطلاعات کافی از API دریافت نشد!",
        ]);
        exit;
    }

    // تولید نمودار و ذخیره فایل
    $chartFile = createFearGreedChart($indexData['data']);

    // تحلیل وضعیت بازار
    $today = $indexData['data'][0];
    $yesterday = $indexData['data'][1] ?? null;
    $lastWeek = $indexData['data'][6] ?? null;

    $analysis = "";
    if ($today['value'] <= 25) {
        $analysis = "📉 *ترس شدید!* معامله‌گران وحشت‌زده هستند. ممکن است فرصت خرید باشد!";
    } elseif ($today['value'] <= 50) {
        $analysis = "⚖️ *ترس!* بازار هنوز اعتماد کافی ندارد. روند نامشخص است.";
    } elseif ($today['value'] <= 75) {
        $analysis = "🚀 *طمع!* بازار صعودی است. معامله‌گران خوش‌بین هستند.";
    } else {
        $analysis = "🔥 *طمع شدید!* احتمال اصلاح قیمت بالا است. مراقب باشید!";
    }

    // متن پیام
    $message = "📊 *شاخص ترس و طمع بازار کریپتو*\n\n" .
               "📅 *امروز (" . date("Y-m-d", $today['timestamp']) . ")*\n" .
               "🔹 مقدار: *{$today['value']}* \n" .
               "🔹 وضعیت: *{$today['value_classification']}*\n\n" .
               "📅 *دیروز (" . ($yesterday ? date("Y-m-d", $yesterday['timestamp']) : 'N/A') . ")*\n" .
               "🔹 مقدار: *" . ($yesterday['value'] ?? 'N/A') . "* \n" .
               "🔹 وضعیت: *" . ($yesterday['value_classification'] ?? 'N/A') . "*\n\n" .
               "📅 *یک هفته قبل (" . ($lastWeek ? date("Y-m-d", $lastWeek['timestamp']) : 'N/A') . ")*\n" .
               "🔹 مقدار: *" . ($lastWeek['value'] ?? 'N/A') . "* \n" .
               "🔹 وضعیت: *" . ($lastWeek['value_classification'] ?? 'N/A') . "*\n\n" .
               "💡 تحلیل وضعیت بازار: \n$analysis\n\n" ;

    // ارسال پیام متنی
    bot('sendMessage',[
        'chat_id'=>$chatid,
        'text'=>$message,
        'parse_mode'=>"Markdown",
        'disable_web_page_preview'=>true
    ]);

    // ارسال تصویر نمودار
    bot('sendPhoto',[
        'chat_id'=>$chatid,
        'photo'=>new CURLFile($chartFile),
        'caption'=>"📊 نمودار شاخص ترس و طمع (۱۰ روز اخیر)",
        'parse_mode'=>"Markdown"
    ]);

    unlink($chartFile);
}
elseif ($data == "currency_rial") {
    fetchCNYRateFromJson($chatid); // استفاده از chat_id کاربر
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 در حال دریافت نرخ ارزها...",
        'reply_markup' => $menu
    ]);
}
elseif ($data == "currency_usd") {
    fetchTopCurrenciesFromJson($chatid); // استفاده از chat_id کاربر
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 در حال دریافت نرخ ارزها...",
        'reply_markup' => $menu
    ]);
}
elseif($data == "investor_analysis"){
    $marketData = getMarketDataFromBinance();
    $topProjects = getTopFundamentalProjectsBinance();
    
    if (!$marketData || !$topProjects) {
        bot('sendMessage',[
            'chat_id'=>$chatid,
            'text'=>"❌ خطا در دریافت داده‌های تحلیل بازار از Binance!",
        ]);
        exit;
    }

    // پیام تحلیل بازار
    $message = "📊 *تحلیل رفتار سرمایه‌گذاران و فاندامنتال*\n\n" .
               "📈 *حجم معاملات کل بازار:* \${$marketData['total_volume']}\n" .
               "⚡️ *دامیننس BTC:* {$marketData['btc_dominance']}%\n" .
               "⏳ *آخرین بروزرسانی:* {$marketData['last_updated']}\n\n" .
               "🔍 *برترین پروژه‌ها بر اساس حجم معاملات:*\n\n";

    foreach ($topProjects as $project) {
        $message .= "🔹 *{$project['symbol']}*\n" .
                    "💵 قیمت: \${$project['price']}\n" .
                    "📊 حجم معاملات: \${$project['volume']}\n" .
                    "📈 تغییر ۲۴ ساعته: *{$project['change']}%*\n\n";
    }

    bot('sendMessage',[
        'chat_id'=>$chatid,
        'text'=>$message,
        'parse_mode'=>"Markdown"
    ]);
}
/* ======= بخش ۲: مدیریت مراحل ثبت هشدار ======= */
elseif ($data == "set_alert") {
    file_put_contents("data/$chatid/state.txt", "select_symbol");
    file_put_contents("data/$chatid/page.txt", "0"); // شماره صفحه اول
    showSymbolsPage($chatid, $messageid, 0);
}

// پردازش صفحات
elseif (strpos($data, "symbol_page:") === 0) {
    $page = (int) str_replace("symbol_page:", "", $data);
    showSymbolsPage($chatid, $messageid, $page);
}

// پردازش انتخاب نماد
elseif (strpos($data, "select_symbol:") === 0) {
    $symbol = str_replace("select_symbol:", "", $data);
    file_put_contents("data/$chatid/symbol.txt", $symbol);
    file_put_contents("data/$chatid/state.txt", "select_direction");
    
    // نمایش انتخاب جهت
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📌 جهت هشدار را برای $symbol انتخاب کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [
                    ['text' => "⬆️ افزایش قیمت", 'callback_data' => "direction_up"],
                    ['text' => "⬇️ کاهش قیمت", 'callback_data' => "direction_down"]
                ],
                [['text' => "❌ لغو", 'callback_data' => "cancel_alert"]]
            ]
        ])
    ]);
}
elseif (in_array($data, ["direction_up", "direction_down"])) {
    $direction = ($data == "direction_up") ? "بالا" : "پایین";
    file_put_contents("data/$chatid/direction.txt", $direction);
    
    // دریافت قیمت فعلی
    $symbol = file_get_contents("data/$chatid/symbol.txt");
    $price = getCurrentPrice($symbol);
    
    if(!$price) {
        bot('editMessageText', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "❌ خطا در دریافت قیمت! لطفا بعدا تلاش کنید."
        ]);
        return;
    }
    
    // ذخیره قیمت فعلی
    file_put_contents("data/$chatid/current_price.txt", $price);
    file_put_contents("data/$chatid/state.txt", "select_percentage");
    
    // نمایش لیست درصدها
    showPercentageMenu($chatid, $messageid, $price, $direction);
}
elseif ($state == "enter_price") {
    // تبدیل قیمت
    $price = str_replace([',', ' '], ['.', ''], $text);
    
    if (!is_numeric($price)) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ فرمت قیمت نامعتبر!\nمثال صحیح: 50000 یا 50,000",
            'parse_mode' => "Markdown"
        ]);
        return;
    }
    
    $price = (float)$price;
    $symbol = file_get_contents("data/$chatid/symbol.txt");
    $direction = file_get_contents("data/$chatid/direction.txt");
    
    // ثبت هشدار
    $alertEntry = "$chatid|$symbol|$direction|$price";
    if (file_put_contents("alerts.txt", $alertEntry . PHP_EOL, FILE_APPEND) === false) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ خطا در ثبت هشدار! لطفا مجددا تلاش کنید."
        ]);
        return;
    }
    
    // پاکسازی وضعیت

    // ارسال تأییدیه
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ *هشدار ثبت شد!*\n\n".
                  "▫️ نماد: `$symbol`\n".
                  "▫️ جهت: $direction\n".
                  "▫️ قیمت: `" . number_format($price, 2, '.', ',') . "`",
        'parse_mode' => "Markdown",
        'reply_markup' => $menu
    ]);
}
elseif ($data == "cancel_alert") {
    // حذف فقط فایلهای مرتبط با هشدار
    $alert_files = [
        "data/$chatid/symbol.txt",
        "data/$chatid/direction.txt",
        "data/$chatid/current_price.txt",
        "data/$chatid/page.txt"
    ];
    
    foreach ($alert_files as $file) {
        if (file_exists($file)) {
            unlink($file);
        }
    }
    
    // بازنشانی وضعیت
    file_put_contents("data/$chatid/state.txt", "none");
    
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "❌ عملیات لغو شد.",
        'reply_markup' => $menu
    ]);
}
elseif (strpos($data, "select_percent:") === 0) {
    $percent = str_replace("select_percent:", "", $data);
    $direction = file_get_contents("data/$chatid/direction.txt");
    $currentPrice = (float)file_get_contents("data/$chatid/current_price.txt");
    
    // محاسبه قیمت هدف
    $targetPrice = $direction == "بالا" 
        ? $currentPrice * (1 + ($percent/100))
        : $currentPrice * (1 - ($percent/100));
    
    // ثبت خودکار
    $symbol = file_get_contents("data/$chatid/symbol.txt");
    $alertEntry = "$chatid|$symbol|$direction|".number_format($targetPrice, 2, '.', '');
    
    file_put_contents("alerts.txt", $alertEntry.PHP_EOL, FILE_APPEND);
    
    // ارسال تأییدیه
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ *هشدار ثبت شد!*\n\n".
                  "▫️ نماد: `$symbol`\n".
                  "▫️ جهت: $direction\n".
                  "▫️ درصد تغییر: $percent%\n".
                  "▫️ قیمت هدف: ".number_format($targetPrice, 2),
        'parse_mode' => "Markdown"
    ]);
}
elseif ($data == "custom_price") {
    file_put_contents("data/$chatid/state.txt", "enter_price");
    
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "💰 لطفا قیمت دقیق مورد نظر را وارد کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "❌ لغو", 'callback_data' => "cancel_alert"]]
            ]
        ])
    ]);
}
elseif($data == "my_alerts") {
    $alerts = [];
    if(file_exists("alerts.txt")) {
        $allAlerts = file("alerts.txt", FILE_IGNORE_NEW_LINES);
        foreach($allAlerts as $alert) {
            list($alertChatId, $symbol, $direction, $target) = explode("|", $alert);
            if($alertChatId == $chatid) {
                $currentPrice = getCurrentPrice($symbol);
                $status = ($direction == "بالا" && $currentPrice >= $target) || 
                          ($direction == "پایین" && $currentPrice <= $target) 
                          ? "✅ فعال" : "🕔 در انتظار";
                $alerts[] = "▫️ $symbol | $direction | " . number_format($target, 2) . " | $status";
            }
        }
    }
    
    if(!empty($alerts)) {
        $message = "🚨 هشدارهای فعال شما:\n\n" . implode("\n", $alerts);
    } else {
        $message = "ℹ️ هیچ هشدار فعالی ندارید";
    }

    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => $message,
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "🗑 حذف همه هشدارها", 'callback_data' => "delete_all_alerts"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}

// پردازش حذف همه هشدارها
elseif($data == "delete_all_alerts") {
    $alerts = [];
    if(file_exists("alerts.txt")) {
        $allAlerts = file("alerts.txt", FILE_IGNORE_NEW_LINES);
        foreach($allAlerts as $alert) {
            list($alertChatId) = explode("|", $alert);
            if($alertChatId != $chatid) {
                $alerts[] = $alert;
            }
        }
    }
    
    file_put_contents("alerts.txt", implode(PHP_EOL, $alerts));
    
    bot('answerCallbackQuery', [
        'callback_query_id' => $callback_query_id,
        'text' => "✅ تمام هشدارهای شما حذف شد",
        'show_alert' => true
    ]);
    
    bot('deleteMessage', [
        'chat_id' => $chatid,
        'message_id' => $messageid
    ]);
}
elseif ($data == "latest_ideas") {
    $ideas = getLatestIdeas();
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => $ideas,
        'parse_mode' => "Markdown",
        'disable_web_page_preview' => false,
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "🔄 بروزرسانی", 'callback_data' => "latest_ideas"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif($data == "ai_advanced_analysis") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 لطفا پارامترهای تحلیل را تنظیم کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "تایم فریم ⏳", 'callback_data' => "set_custom_timeframe"]],
                [['text' => "تعداد کندل 📊", 'callback_data' => "set_candle_limit"]],
                [['text' => "نماد ارز 🔣", 'callback_data' => "select_symbol_menu"]],
                [['text' => "اندیکاتور ها 💾", 'callback_data' => "indicators_menu"]],
                [['text' => "شروع تحلیل 🚀", 'callback_data' => "run_analysis"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "ai_analysis"]]
            ]
        ])
    ]);
}
elseif($data == "indicators_menu") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📈 *انتخاب اندیکاتورها*\n\nاندیکاتورهای فعال: RSI, MACD, Bollinger",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
[['text' => "RSI", 'callback_data' => "rsi3"],
['text' => "📊 CDV", 'callback_data' => "cdv_settings"]],
[['text' => "bollinger", 'callback_data' => "set_bollinger_params"],
['text' => "MACD", 'callback_data' => "set_macd_params"]],
[['text' => "Donchian Channels", 'callback_data' => "set_donchian_params"],
['text' => "📊 Williams %R", 'callback_data' => "williams_r_settings"]],
[['text' => "📊 ROC", 'callback_data' => "roc_settings"],
['text' => "📊 Pivot Points", 'callback_data' => "pivot"]],
[['text' => "📊 PPO", 'callback_data' => "ppo"],
['text' => "📊 Moving Median", 'callback_data' => "moving_median_settings"]],
[['text' => "📊 Fibonacci Retracement", 'callback_data' => "fibonacci"],
['text' => "📊 VWAP", 'callback_data' => "vwap"]],
[['text' => "Stochastic", 'callback_data' => "stochastic_settings"],
['text' => "CCI", 'callback_data' => "cci_settings"]],
[['text' => "parabolic sar", 'callback_data' => "set_parabolic_sar_params"],
['text' => "keltner", 'callback_data' => "set_keltner_params"]],
[['text' => "ichimoku", 'callback_data' => "set_ichimoku_params"],
['text' => "ADX & ATR", 'callback_data' => "set_atr_adx_params"]],
[['text' => "📊 MFI (Money Flow Index)", 'callback_data' => "mfi_settings"],
['text' => "📊 OBV (On Balance Volume)", 'callback_data' => "obv"]],
[['text' => "📊 Fisher Transform", 'callback_data' => "fisher_settings"],
['text' => "📊 Gann Fan", 'callback_data' => "gann_fan_settings"]],
[['text' => "📊 Heikin Ashi Smoothed", 'callback_data' => "heikin_ashi"],
['text' => "📊 RVI (Relative Vigor Index)", 'callback_data' => "rvi_settings"]],
[['text' => "📊 Schaff Trend Cycle (STC)", 'callback_data' => "stc_settings"],
['text' => "📊 Historical Volatility (HV)", 'callback_data' => "hv_settings"]],
[['text' => "📊 Zig Zag", 'callback_data' => "zigzag_settings"],
['text' => "📊 Renko Charts", 'callback_data' => "renko_settings"]],
[['text' => "📊 (AD Line)", 'callback_data' => "ad_line_settings"]],
[['text' => "🔙 بازگشت", 'callback_data' => "ai_advanced_analysis"]]
]
        ])
    ]);
}
elseif ($data == "cdv_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Cumulative Delta Volume (CDV)\n\n📌 این اندیکاتور نیاز به داده‌های Order Flow دارد و مقدار خاصی برای تنظیم ندارد.\n\nفقط بازه زمانی مناسب را انتخاب کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ 1 دقیقه", 'callback_data' => "set_cdv_1m"]],
                [['text' => "✅ 5 دقیقه", 'callback_data' => "set_cdv_5m"]],
                [['text' => "✅ 15 دقیقه", 'callback_data' => "set_cdv_15m"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ]),
        'parse_mode' => "Markdown"
    ]);
}

elseif (in_array($data, ["set_cdv_1m", "set_cdv_5m", "set_cdv_15m"])) {
    $timeframe = str_replace("set_cdv_", "", $data);
    file_put_contents("data/{$chatid}/cdv_timeframe.txt", $timeframe);

    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ بازه زمانی CDV روی $timeframe تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $settings_menu
    ]);
}
elseif ($data == "renko_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Renko Charts\n\n📌 مقدار پیش‌فرض اندازه آجر: 10 واحد\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 10", 'callback_data' => "confirm_renko_10"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}

elseif ($data == "confirm_renko_10") {
    file_put_contents("data/{$chatid}/renko_brick_size.txt", 10);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار Renko Charts روی ۱۰ واحد قیمت تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif(strpos($data, "selected_symbol_") === 0) {
    $symbol = str_replace("selected_symbol_", "", $data);
    
    // اعتبارسنجی فرمت نماد
   
    
    file_put_contents("data/$chatid/selected_symbol.txt", $symbol);
    
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✅ نماد $symbol انتخاب شد",
        'reply_markup' => $menu
    ]);
}
elseif($data == "custom_symbol_input") {
    file_put_contents("data/$chatid/state.txt", "awaiting_custom_symbol");
    
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✏️ نماد خود را وارد کنید (مثال: BTC/USDT):",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "❌ لغو", 'callback_data' => "cancel_symbol_input"]]
            ]
        ])
    ]);
}

elseif($state == "awaiting_custom_symbol") {
    // اعتبارسنجی پیشرفته
    if(!preg_match('/^[A-Z]{3,20}\/[A-Z]{3,20}$/', $text)) {
        bot('sendMessage',[
            'chat_id' => $chatid,
            'text' => "❌ فرمت نامعتبر!\nمثال صحیح: BTC/USDT"
        ]);
        return;
    }
    
    // بررسی وجود نماد در لیست بایننس
    $url = "https://api.binance.com/api/v3/ticker/price?symbol=".str_replace('/', '', $text);
    $response = json_decode(file_get_contents($url), true);
    
    if(isset($response['code'])) {
        bot('sendMessage',[
            'chat_id' => $chatid,
            'text' => "⚠️ نماد $text یافت نشد!\nلیست نمادها: binance.com/en/markets"
        ]);
        return;
    }
    
    file_put_contents("data/$chatid/selected_symbol.txt", $text);
    
    bot('sendMessage',[
        'chat_id' => $chatid,
        'text' => "✅ نماد سفارشی $text ثبت شد",
        'reply_markup' => $menu
    ]);
}
elseif($data == "select_symbol_menu") {
    $popularSymbols = [
        'BTCUSDT', 'ETHUSDT', 'BNBUSDT', 
        'XRPUSDT', 'ADAUSDT', 'DOTUSDT'
    ];
    
    $keyboard = [];
    foreach ($popularSymbols as $symbol) {
        $keyboard[] = [['text' => $symbol, 'callback_data' => "selected_symbol_$symbol"]];
    }
    $keyboard[] = [['text' => "سفارشی ✏️", 'callback_data' => "custom_symbol_input"]];
    $keyboard[] = [['text' => "بازگشت ↩️", 'callback_data' => "back"]];
    
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "🔣 لطفا نماد مورد نظر را انتخاب کنید:",
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}
elseif($data == "run_analysis") {
    $symbol = file_get_contents("data/$chatid/selected_symbol.txt");
    $timeframe = file_get_contents("data/$chatid/timeframe.txt") ?? '1h';
    $limit = file_get_contents("data/$chatid/candle_limit.txt") ?? 100;    
    $chartData = getBinanceChartData($symbol, $timeframe, $limit);
    $period = file_get_contents("data/$chatid/bollinger_period.txt") ?? 20;
    $deviation = file_get_contents("data/$chatid/bollinger_deviation.txt") ?? 2;
    $fastPeriod = file_get_contents("data/$chatid/macd_fast.txt") ?? 12;
    $slowPeriod = file_get_contents("data/$chatid/macd_slow.txt") ?? 26;
    $signalPeriod = file_get_contents("data/$chatid/macd_signal.txt") ?? 9;
    $atrValues = calculateATR($chartData);
    $lastATR = end($atrValues);
    $adxData = calculateADX($chartData);
    $lastADX = end($adxData['adx']);
    $lastPlusDI = end($adxData['plus_di']);
    $lastMinusDI = end($adxData['minus_di']);
    $macdData = calculateMACD($chartData, $fastPeriod, $slowPeriod, $signalPeriod);
    $lastMACD = end($macdData['macd']);
    $lastSignal = end($macdData['signal']);
    $lastHistogram = end($macdData['histogram']);
    $bollinger = calculateBollingerBands($chartData, $period, $deviation);

$ichimokuData = calculateIchimoku($chartData);
$lastIchimoku = end($ichimokuData);

    $lastBand = end($bollinger);

    if(!$chartData) {
        bot('sendMessage',[
            'chat_id' => $chatid,
            'text' => "❌ خطا در دریافت داده‌های بازار!"
        ]);
        return;
    }
    
    $rsiValues = calculateRSI($chartData, 14, $limit);
    $latestRSI = end($rsiValues);
    
    $signal = "";
    if($latestRSI < 30) {
        $signal = "🟢 سیگنال خرید (اشباع فروش)";
    } elseif($latestRSI > 70) {
        $signal = "🔴 سیگنال فروش (اشباع خرید)";
    } else {
        $signal = "⚪️ وضعیت خنثی";
    }
    
    $message .= "📊 تحلیل  برای $symbol\n\n";
    $message .= "⏰ تایم فریم: " . strtoupper($timeframe) . "\n";
    $message .= "🔢 تعداد کندل: $limit\n\n";
    $message .= "📈 آخرین مقدار RSI: " . round($latestRSI, 2) . "\n";
    $message .= "📌 سیگنال: $signal\n\n";
    $message .= "\n📊 *MACD*\n";
    $message .= "▫️ خط MACD: " . round($lastMACD, 4) . "\n";
    $message .= "▫️ خط سیگنال: " . round($lastSignal, 4) . "\n";
    $message .= "▫️ هیستوگرام: " . round($lastHistogram, 4) . "\n";
    if($lastMACD > $lastSignal) {
    $message .= "✅ سیگنال: صعودی (خرید)\n";
    } else {
    $message .= "❌ سیگنال: نزولی (فروش)\n";
    }
    $message .= "\n📈 *Bollinger Bands*\n";
    $message .= "▫️ Upper: " . round($lastBand['upper'], 2) . "\n";
    $message .= "▫️ Middle: " . round($lastBand['middle'], 2) . "\n";
    $message .= "▫️ Lower: " . round($lastBand['lower'], 2) . "\n";

    $currentPrice = end($chartData)[4];
    if($currentPrice > $lastBand['upper']) {
    $message .= "⚠️ قیمت بالای باند بالا (اشباع خرید)\n";
    } elseif($currentPrice < $lastBand['lower']) {
    $message .= "⚠️ قیمت زیر باند پایین (اشباع فروش)\n";
    } else {
    $message .= "✅ قیمت در محدوده نرمال\n";
    }

$message .= "\n☁️ *ایچیموکو*\n";
$message .= "▫️ تنکان سن: " . round($lastIchimoku['tenkan_sen'], 2) . "\n";
$message .= "▫️ کیجون سن: " . round($lastIchimoku['kijun_sen'], 2) . "\n";
$message .= "▫️ سنکو اسپن A: " . round($lastIchimoku['senkou_span_a'], 2) . "\n";
$message .= "▫️ سنکو اسپن B: " . round($lastIchimoku['senkou_span_b'], 2) . "\n";
$message .= "▫️ چیکو اسپن: " . round($lastIchimoku['chikou_span'], 2) . "\n";

if ($lastIchimoku['senkou_span_a'] > $lastIchimoku['senkou_span_b']) {
    $message .= "✅ ابر صعودی (روند صعودی)\n";
} else {
    $message .= "❌ ابر نزولی (روند نزولی)\n";
}

if ($lastIchimoku['tenkan_sen'] > $lastIchimoku['kijun_sen']) {
    $message .= "📈 سیگنال خرید (تنکان سن بالای کیجون سن)\n";
} else {
    $message .= "📉 سیگنال فروش (تنکان سن زیر کیجون سن)\n";
}
$message .= "\n📏 *ATR*\n";
$message .= "▫️ مقدار ATR: " . round($lastATR, 2) . "\n";
if ($lastATR > 50) {
    $message .= "⚠️ نوسانات بالا (مراقب باشید)\n";
} else {
    $message .= "✅ نوسانات نرمال\n";
}
$message .= "\n📊 *ADX*\n";
$message .= "▫️ مقدار ADX: " . round($lastADX, 2) . "\n";
$message .= "▫️ +DI: " . round($lastPlusDI, 2) . "\n";
$message .= "▫️ -DI: " . round($lastMinusDI, 2) . "\n";

// تحلیل ADX
if ($lastADX > 25) {
    $message .= "✅ روند قوی\n";
} else {
    $message .= "⚠️ روند ضعیف\n";
}

// تحلیل +DI و -DI
if ($lastPlusDI > $lastMinusDI) {
    $message .= "📈 روند صعودی\n";
} else {
    $message .= "📉 روند نزولی\n";
}
if(count($chartData) < 52) {
    bot('sendMessage',[
        'chat_id' => $chatid,
        'text' => "⚠️ داده‌ها کافی نیستند! حداقل ۵۲ کندل نیاز است."
    ]);
    return;
}
$emaPeriod = file_get_contents("data/{$chatid}/keltner_ema.txt") ?? 20;
$atrPeriod = file_get_contents("data/{$chatid}/keltner_atr.txt") ?? 10;
$multiplier = file_get_contents("data/{$chatid}/keltner_multiplier.txt") ?? 2;

$keltner = calculateKeltnerChannel($chartData, $emaPeriod, $atrPeriod, $multiplier);
$lastKeltner = end($keltner);

$message .= "\n📊 *کانال کلتنر*\n";
$message .= "▫️ خط بالا: " . round($lastKeltner['upper'], 2) . "\n";
$message .= "▫️ خط وسط: " . round($lastKeltner['middle'], 2) . "\n";
$message .= "▫️ خط پایین: " . round($lastKeltner['lower'], 2) . "\n";

// تحلیل سیگنال
$currentPrice = end($chartData)[4];
if ($currentPrice > $lastKeltner['upper']) {
    $message .= "⚠️ قیمت بالای کانال (اشباع خرید)\n";
} elseif ($currentPrice < $lastKeltner['lower']) {
    $message .= "⚠️ قیمت زیر کانال (اشباع فروش)\n";
} else {
    $message .= "✅ قیمت در محدوده نرمال\n";
}
$afStart = file_get_contents("data/{$chatid}/sar_af_start.txt") ?? 0.02;
$afIncrement = file_get_contents("data/{$chatid}/sar_af_inc.txt") ?? 0.02;
$afMax = file_get_contents("data/{$chatid}/sar_af_max.txt") ?? 0.20;

$sarValues = calculateParabolicSAR($chartData, $afStart, $afIncrement, $afMax);
$lastSar = end($sarValues);
$currentPrice = end($chartData)[4];

$message .= "\n🎯 *Parabolic SAR*\n";
$message .= "▫️ SAR فعلی: " . round($lastSar, 2) . "\n";
$message .= "▫️ قیمت فعلی: " . round($currentPrice, 2) . "\n";

// تحلیل سیگنال
if ($currentPrice > $lastSar) {
    $message .= "✅ سیگنال خرید (قیمت بالای SAR)\n";
} else {
    $message .= "❌ سیگنال فروش (قیمت زیر SAR)\n";
}
$donchianPeriod = file_get_contents("data/{$chatid}/donchian_period.txt") ?: 20;
$donchian = calculateDonchianChannels($chartData, $donchianPeriod);

// بررسی اینکه مقدار معتبر وجود دارد
$lastDonchian = [
    'upper' => end($donchian['upper']) ?? 0,
    'middle' => end($donchian['middle']) ?? 0,
    'lower' => end($donchian['lower']) ?? 0
];

$message .= "\n📉 *Donchian Channels*\n";
$message .= "▫️ کانال بالا: " . round($lastDonchian['upper'], 2) . "\n";
$message .= "▫️ کانال وسط: " . round($lastDonchian['middle'], 2) . "\n";
$message .= "▫️ کانال پایین: " . round($lastDonchian['lower'], 2) . "\n";

// تحلیل سیگنال
$currentPrice = end($chartData)[4] ?? 0;
if ($currentPrice > $lastDonchian['upper'] && $lastDonchian['upper'] > 0) {
    $message .= "✅ شکست مقاومت (سیگنال خرید)\n";
} elseif ($currentPrice < $lastDonchian['lower'] && $lastDonchian['lower'] > 0) {
    $message .= "❌ شکست حمایت (سیگنال فروش)\n";
} else {
    $message .= "⚪️ قیمت در محدوده کانال\n";
}
 $cciPeriod = file_get_contents("data/{$chatid}/cci_period.txt") ?: 20;
    $cci = calculateCCI($chartData, $cciPeriod);
    $lastCCI = end($cci) ?? 0; // مقدار آخرین CCI
    $message .= "📊 CCI: " . round($lastCCI, 2) . "\n";

    // تحلیل سیگنال CCI
    if ($lastCCI > 100) {
        $message .= "✅ روند قوی صعودی (سیگنال خرید)\n";
    } elseif ($lastCCI < -100) {
        $message .= "❌ روند نزولی قوی (سیگنال فروش)\n";
    } else {
        $message .= "⚪️ روند خنثی در کانال نوسانی\n";
    }
        $stochasticPeriod = file_get_contents("data/{$chatid}/stochastic_period.txt") ?: 14;
    $stochastic = calculateStochastic($chartData, $stochasticPeriod);
    $lastK = end($stochastic['k']) ?? 0;
    $lastD = end($stochastic['d']) ?? 0;
        $message .= "📊 Stochastic\n";
    $message .= "▫️ %K: " . round($lastK, 2) . "\n";
    $message .= "▫️ %D: " . round($lastD, 2) . "\n";

    // تحلیل سیگنال Stochastic
    if ($lastK > 80 && $lastD > 80) {
        $message .= "❌ منطقه خرید بیش‌ازحد (Overbought) → احتمال اصلاح قیمت\n";
    } elseif ($lastK < 20 && $lastD < 20) {
        $message .= "✅ منطقه فروش بیش‌ازحد (Oversold) → احتمال برگشت صعودی\n";
    } elseif ($lastK > $lastD && $lastD < 50) {
        $message .= "✅ کراس صعودی %K و %D → سیگنال خرید\n";
    } elseif ($lastK < $lastD && $lastD > 50) {
        $message .= "❌ کراس نزولی %K و %D → سیگنال فروش\n";
    } else {
        $message .= "⚪️ روند نرمال بدون سیگنال مشخص\n";
    }
        $rocPeriod = file_get_contents("data/{$chatid}/roc_period.txt") ?: 14;
    $roc = calculateROC($chartData, $rocPeriod);
    $lastROC = end($roc) ?? 0;
        $message .= "📊 ROC (Rate of Change)\n";
    $message .= "▫️ مقدار ROC: " . round($lastROC, 2) . "%\n";

    // تحلیل سیگنال ROC
    if ($lastROC > 5) {
        $message .= "✅ مومنتوم قوی صعودی → سیگنال خرید\n";
    } elseif ($lastROC < -5) {
        $message .= "❌ مومنتوم قوی نزولی → سیگنال فروش\n";
    } else {
        $message .= "⚪️ مومنتوم ضعیف → روند خنثی\n";
    }
        $pivotPoints = calculatePivotPoints($chartData);
    $currentPrice2 = end($chartData)[4] ?? 0; // آخرین قیمت بسته شدن
        $message .= "📊 Pivot Points\n";
    $message .= "▫️ Pivot: " . round($pivotPoints['pivot'], 2) . "\n";
    $message .= "▫️ R1: " . round($pivotPoints['resistance1'], 2) . "\n";
    $message .= "▫️ R2: " . round($pivotPoints['resistance2'], 2) . "\n";
    $message .= "▫️ R3: " . round($pivotPoints['resistance3'], 2) . "\n";
    $message .= "▫️ S1: " . round($pivotPoints['support1'], 2) . "\n";
    $message .= "▫️ S2: " . round($pivotPoints['support2'], 2) . "\n";
    $message .= "▫️ S3: " . round($pivotPoints['support3'], 2) . "\n";

    // تحلیل سیگنال Pivot Points
    if ($currentPrice2 > $pivotPoints['pivot']) {
        $message .= "✅ قیمت بالاتر از Pivot → احتمال ادامه روند صعودی\n";
    } elseif ($currentPrice2 < $pivotPoints['pivot']) {
        $message .= "❌ قیمت پایین‌تر از Pivot → احتمال ادامه روند نزولی\n";
    } else {
        $message .= "⚪️ قیمت نزدیک Pivot → احتمال نوسان جانبی\n";
    }
        $ppo = calculatePPO($chartData);
    $lastPPO = end($ppo['ppo']) ?? 0;
    $lastSignal = end($ppo['signal']) ?? 0;
    $lastHistogram = end($ppo['histogram']) ?? 0;
        $message .= "📊 PPO (Percentage Price Oscillator)\n";
    $message .= "▫️ PPO: " . round($lastPPO, 2) . "%\n";
    $message .= "▫️ Signal: " . round($lastSignal, 2) . "%\n";
    $message .= "▫️ Histogram: " . round($lastHistogram, 2) . "%\n";

    // تحلیل سیگنال PPO
    if ($lastPPO > $lastSignal && $lastHistogram > 0) {
        $message .= "✅ سیگنال خرید (PPO > Signal Line و Histogram مثبت)\n";
    } elseif ($lastPPO < $lastSignal && $lastHistogram < 0) {
        $message .= "❌ سیگنال فروش (PPO < Signal Line و Histogram منفی)\n";
    } else {
        $message .= "⚪️ روند نامشخص، منتظر تأیید بیشتر باشید.\n";
    }
        $movingMedian = calculateMovingMedian($chartData, 20);
    $lastMedian = end($movingMedian) ?? 0;
        $message .= "📊 Moving Median\n";
    $message .= "▫️ مقدار Median: " . round($lastMedian, 2) . "\n";

    // تحلیل سیگنال Moving Median
    if ($currentPrice > $lastMedian) {
        $message .= "✅ قیمت بالاتر از Median → روند صعودی\n";
    } elseif ($currentPrice < $lastMedian) {
        $message .= "❌ قیمت پایین‌تر از Median → روند نزولی\n";
    } else {
        $message .= "⚪️ قیمت نزدیک Median → روند خنثی\n";
    }
        $fibonacci = calculateFibonacciRetracement($chartData);
            $message .= "📊 Fibonacci Retracement\n";
    foreach ($fibonacci as $level => $price) {
        $message .= "▫️ $level: " . round($price, 2) . "\n";
    }

    // تحلیل سیگنال Fibonacci
    if ($currentPrice > $fibonacci['61.8%']) {
        $message .= "✅ قیمت بالاتر از 61.8% → احتمال ادامه روند صعودی\n";
    } elseif ($currentPrice < $fibonacci['38.2%']) {
        $message .= "❌ قیمت پایین‌تر از 38.2% → احتمال اصلاح نزولی\n";
    } else {
        $message .= "⚪️ قیمت بین سطوح فیبوناچی → احتمال نوسان جانبی\n";
    }
        $williamsPeriod = file_get_contents("data/{$chatid}/williams_r_period.txt") ?: 14;
    $williamsR = calculateWilliamsR($chartData, $williamsPeriod);
    $lastWilliamsR = end($williamsR) ?? 0;
        $message .= "📊 Williams %R (دوره: $williamsPeriod)\n";
    $message .= "▫️ مقدار: " . round($lastWilliamsR, 2) . "\n";

    // تحلیل سیگنال Williams %R
    if ($lastWilliamsR > -20) {
        $message .= "❌ خرید بیش‌ازحد (Overbought) → احتمال اصلاح قیمت\n";
    } elseif ($lastWilliamsR < -80) {
        $message .= "✅ فروش بیش‌ازحد (Oversold) → احتمال بازگشت صعودی\n";
    } else {
        $message .= "⚪️ روند نرمال بدون سیگنال مشخص\n";
    }
        $vwap = calculateVWAP($chartData);
    $lastVWAP = end($vwap) ?? 0;
        $message .= "📊 VWAP (Volume Weighted Average Price)\n";
    $message .= "▫️ مقدار VWAP: " . round($lastVWAP, 2) . "\n";

    // تحلیل سیگنال VWAP
    if ($currentPrice > $lastVWAP) {
        $message .= "✅ قیمت بالاتر از VWAP → روند صعودی و قدرت خریداران\n";
    } elseif ($currentPrice < $lastVWAP) {
        $message .= "❌ قیمت پایین‌تر از VWAP → روند نزولی و قدرت فروشندگان\n";
    } else {
        $message .= "⚪️ قیمت نزدیک VWAP → احتمال نوسان یا تجمیع\n";
    }
        $mfiPeriod = file_get_contents("data/{$chatid}/mfi_period.txt") ?: 14;
    $mfi = calculateMFI($chartData, $mfiPeriod);
    $lastMFI = end($mfi) ?? 0;
        $message .= "📊 MFI (Money Flow Index) (دوره: $mfiPeriod)\n";
    $message .= "▫️ مقدار: " . round($lastMFI, 2) . "\n";

    // تحلیل سیگنال MFI
    if ($lastMFI > 80) {
        $message .= "❌ خرید بیش‌ازحد (Overbought) → احتمال اصلاح قیمت\n";
    } elseif ($lastMFI < 20) {
        $message .= "✅ فروش بیش‌ازحد (Oversold) → احتمال بازگشت صعودی\n";
    } else {
        $message .= "⚪️ روند نرمال بدون سیگنال مشخص\n";
    }
        $obv = calculateOBV($chartData);
    $lastOBV = end($obv) ?? 0;
    $prevOBV = $obv[count($obv) - 2] ?? 0;
    $message .= "📊 OBV (On Balance Volume)\n";
    $message .= "▫️ مقدار OBV: " . number_format($lastOBV) . "\n";

    // تحلیل سیگنال OBV
    if ($lastOBV > $prevOBV) {
        $message .= "✅ افزایش OBV → تأیید روند صعودی و قدرت خریداران\n";
    } elseif ($lastOBV < $prevOBV) {
        $message .= "❌ کاهش OBV → تأیید روند نزولی و قدرت فروشندگان\n";
    } else {
        $message .= "⚪️ OBV بدون تغییر → احتمال نوسان یا تجمیع\n";
    }
$fisherPeriod = file_exists("data/{$chatid}/fisher_period.txt") 
    ? (int) file_get_contents("data/{$chatid}/fisher_period.txt") 
    : 10;

// بررسی مقدار تایم‌فریم داده‌ها
if (count($chartData) < $fisherPeriod) {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "❌ تعداد داده‌های موجود برای محاسبه Fisher Transform کافی نیست. لطفاً تایم‌فریم طولانی‌تری انتخاب کنید.",
        'reply_markup' => $back2menu
    ]);
    return;
}

$fisher = calculateFisherTransform($chartData, $fisherPeriod);
$lastFisher = is_array($fisher) && count($fisher) > 0 ? end($fisher) : null;
$message .= "📊 Fisher Transform (دوره: $fisherPeriod)\n";

if ($lastFisher === null) {
    $message .= "⚠️ مقدار Fisher محاسبه نشد. داده‌های کافی وجود ندارد.\n";
} else {
    $message .= "▫️ مقدار: " . round($lastFisher, 2) . "\n";

    // تحلیل سیگنال Fisher Transform
    if ($lastFisher > 1) {
        $message .= "✅ Fisher > 1 → احتمال ادامه روند صعودی\n";
    } elseif ($lastFisher < -1) {
        $message .= "❌ Fisher < -1 → احتمال ادامه روند نزولی\n";
    } else {
        $message .= "⚪️ Fisher بین -1 و 1 → روند خنثی یا نوسانی\n";
    }
}
    $gannPeriod = file_get_contents("data/{$chatid}/gann_fan_period.txt") ?: 50;
    $anchorIndex = count($chartData) - $gannPeriod;

    if ($anchorIndex < 0) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ تعداد کندل‌های کافی برای محاسبه Gann Fan وجود ندارد.",
            'reply_markup' => $back2menu
        ]);
        return;
    }

    $gannLevels = calculateGannFan($chartData, $anchorIndex);
        $message .= "📊 Gann Fan (آخرین $gannPeriod کندل)\n";

    if ($currentPrice > end($gannLevels['1x1'])) {
        $message .= "✅ قیمت بالای زاویه 1x1 → روند صعودی قوی\n";
    } elseif ($currentPrice < end($gannLevels['1x1'])) {
        $message .= "❌ قیمت زیر زاویه 1x1 → روند نزولی قوی\n";
    } else {
        $message .= "⚪️ قیمت بین خطوط Gann → احتمال نوسان یا تثبیت قیمت\n";
    }
    $heikinAshi = calculateHeikinAshiSmoothed($chartData);
    $lastCandle = end($heikinAshi);

    // بررسی اینکه مقدار lastCandle معتبر باشد
    if (!$lastCandle || !isset($lastCandle['open'], $lastCandle['close'], $lastCandle['high'], $lastCandle['low'])) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ خطا در محاسبه Heikin Ashi Smoothed. لطفاً دوباره تلاش کنید.",
            'reply_markup' => $back2menu
        ]);
        return;
    }
    $message .= "📊 Heikin Ashi Smoothed\n";
    $message .= "▫️ Open: " . round($lastCandle['open'], 2) . "\n";
    $message .= "▫️ Close: " . round($lastCandle['close'], 2) . "\n";
    $message .= "▫️ High: " . round($lastCandle['high'], 2) . "\n";
    $message .= "▫️ Low: " . round($lastCandle['low'], 2) . "\n";

    // تحلیل سیگنال Heikin Ashi Smoothed
    if ($lastCandle['close'] > $lastCandle['open']) {
        $message .= "✅ کندل سبز → روند صعودی قوی (سیگنال خرید)\n";
    } elseif ($lastCandle['close'] < $lastCandle['open']) {
        $message .= "❌ کندل قرمز → روند نزولی قوی (سیگنال فروش)\n";
    } else {
        $message .= "⚪️ کندل کوچک → احتمال تغییر روند\n";
    }
    $rviPeriod = file_get_contents("data/{$chatid}/rvi_period.txt") ?: 10;
    $rvi = calculateRVI($chartData, $rviPeriod);
    $lastRVI = end($rvi) ?? 0;
    $message .= "📊 RVI (Relative Vigor Index) (دوره: $rviPeriod)\n";
    $message .= "▫️ مقدار: " . round($lastRVI, 4) . "\n";

    // تحلیل سیگنال RVI
    if ($lastRVI > 0) {
        $message .= "✅ RVI مثبت → روند صعودی (قدرت خرید)\n";
    } elseif ($lastRVI < 0) {
        $message .= "❌ RVI منفی → روند نزولی (قدرت فروش)\n";
    } else {
        $message .= "⚪️ RVI در نقطه صفر → روند خنثی\n";
    }
$stcPeriod = file_exists("data/{$chatid}/stc_period.txt") 
        ? (int) file_get_contents("data/{$chatid}/stc_period.txt") 
        : 10;

    $stc = calculateSTC($chartData, 12, 26, 9, $stcPeriod);
    $lastSTC = is_array($stc) && count($stc) > 0 ? end($stc) : null;

    // بررسی مقدار STC برای جلوگیری از نمایش مقدار صفر یا نامعتبر
    if ($lastSTC === null) {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ خطا در محاسبه STC. لطفاً دوباره تلاش کنید.",
            'reply_markup' => $back2menu
        ]);
        return;
    }
    $message .= "📊 STC (Schaff Trend Cycle) (دوره: $stcPeriod)\n";
    $message .= "▫️ مقدار: " . round($lastSTC, 2) . "\n";

    // تحلیل سیگنال STC
    if ($lastSTC > 75) {
        $message .= "❌ STC > 75 → اشباع خرید (احتمال اصلاح قیمت)\n";
    } elseif ($lastSTC < 25) {
        $message .= "✅ STC < 25 → اشباع فروش (احتمال بازگشت صعودی)\n";
    } else {
        $message .= "⚪️ STC بین 25 و 75 → روند عادی\n";
    }
    $zigzagThreshold = file_exists("data/{$chatid}/zigzag_threshold.txt") 
        ? (int) file_get_contents("data/{$chatid}/zigzag_threshold.txt") 
        : 5;

    $zigzag = calculateZigZag($chartData, $zigzagThreshold);
    $lastZigZag = end($zigzag);
    $prevZigZag = prev($zigzag);
    $message .= "📊 Zig Zag (حد تغییرات: $zigzagThreshold%)\n";
    $message .= "▫️ آخرین نقطه Zig Zag: " . round($lastZigZag['price'], 2) . "\n";

    // تحلیل روند صعودی یا نزولی
    if ($lastZigZag['price'] > $prevZigZag['price']) {
        $message .= "✅ روند صعودی تایید شده → احتمال ادامه افزایش قیمت\n";
    } else {
        $message .= "❌ روند نزولی تایید شده → احتمال کاهش قیمت\n";
    }

    // تحلیل شکست سطوح قبلی
    $currentPrice = end($chartData)[4]; // قیمت آخرین کندل
    if ($currentPrice > $lastZigZag['price']) {
        $message .= "🔼 قیمت از آخرین سقف Zig Zag عبور کرده → شکست مقاومت (سیگنال خرید)\n";
    } elseif ($currentPrice < $lastZigZag['price']) {
        $message .= "🔽 قیمت زیر آخرین کف Zig Zag قرار دارد → شکست حمایت (سیگنال فروش)\n";
    } else {
        $message .= "⚪️ قیمت نزدیک به آخرین Zig Zag است → محدوده نوسانی\n";
    }
        $brickSize = file_exists("data/{$chatid}/renko_brick_size.txt") 
        ? (int) file_get_contents("data/{$chatid}/renko_brick_size.txt") 
        : 10;

    $renko = calculateRenko($chartData, $brickSize);
    $lastRenko = end($renko);
        $message .= "📊 Renko Charts (اندازه آجر: $brickSize واحد)\n";
    $message .= "▫️ آخرین قیمت آجر: " . round($lastRenko['price'], 2) . "\n";

    if ($lastRenko['trend'] === 'up') {
        $message .= "✅ روند صعودی → سیگنال خرید\n";
    } else {
        $message .= "❌ روند نزولی → سیگنال فروش\n";
    }
        $hvPeriod = file_exists("data/{$chatid}/hv_period.txt") ? (int) file_get_contents("data/{$chatid}/hv_period.txt") : 20;
    $hvValue = calculateHV($chartData, $hvPeriod);
        if ($hvValue !== null) {
        $message .= "📊 Historical Volatility (HV): " . round($hvValue, 2) . "% → ";
        if ($hvValue > 60) {
            $message .= "⚠️ بازار پرنوسان و بی‌ثبات\n";
        } elseif ($hvValue < 20) {
            $message .= "✅ بازار آرام و با ثبات\n";
        } else {
            $message .= "⚪️ نوسانات متعادل در بازار\n";
        }
    }
        $message .= "📊 Cumulative Delta Volume (CDV): " . round($lastCDV, 2) . " → ";

    // تحلیل سیگنال‌های CDV
    if ($lastCDV > 0) {
        $message .= "✅ خریداران قوی‌تر هستند (روند صعودی)\n";
    } elseif ($lastCDV < 0) {
        $message .= "❌ فروشندگان کنترل دارند (روند نزولی)\n";
    } else {
        $message .= "در دست ساخت";
    }
    $cdv = calculateCDV($cdvData);
    
    // بررسی مقدار CDV قبل از پردازش

    $lastCDV = end($cdv);
    $adLine = calculateADLine($chartData);
    $lastAD = end($adLine) ?? null;
     if ($lastAD !== null) {
        $message .= "📊 AD Line : " . round($lastAD, 2) . " → ";
        if ($lastAD > end($adLine) - 2) {
            $message .= "✅ Accumulation → احتمال روند صعودی\n";
        } elseif ($lastAD < end($adLine) - 2) {
            $message .= "❌ Distribution → احتمال روند نزولی\n";
        } else {
            $message .= "⚪️ بازار در تعادل است\n";
        }
    }
    bot('sendMessage',[
        'chat_id' => $chatid,
        'text' => $message,
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "🔄 بروزرسانی", 'callback_data' => "run_analysis"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "ai_analysis"]]
            ]
        ])
    ]);
}
elseif ($data == "ad_line_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات AD Line\n\n📌 این اندیکاتور مقدار خاصی برای تنظیم ندارد و به داده‌های حجم معاملات و قیمت بستگی دارد.",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "🔙 بازگشت", 'callback_data' => "settings_menu"]]
            ]
        ]),
        'parse_mode' => "Markdown"
    ]);
}
elseif ($data == "currency_rates") {
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "💱 *نرخ ارزها*\n\nلطفاً واحد موردنظر را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "به ریال 🇮🇷", 'callback_data' => "currency_rial"]],
                [['text' => "به دلار 🇺🇸", 'callback_data' => "currency_usd"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back_to_menu"]]
            ]
        ])
    ]);
}
elseif($data == "set_custom_timeframe") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⏰ *انتخاب تایم فریم*\n\nلطفا یکی از گزینه‌ها را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "۱ دقیقه", 'callback_data' => "tf_1m"]],
                [['text' => "۵ دقیقه", 'callback_data' => "tf_5m"]],
                [['text' => "۱۵ دقیقه", 'callback_data' => "tf_15m"]],
                [['text' => "۱ ساعت", 'callback_data' => "tf_1h"]],
                [['text' => "۴ ساعت", 'callback_data' => "tf_4h"]],
                [['text' => "۱ روز", 'callback_data' => "tf_1d"]],
                [['text' => "سفارشی ✏️", 'callback_data' => "tf_custom"]],
                [['text' => "❌ لغو", 'callback_data' => "cancel_timeframe"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "cancel_symbol_input") === 0) {
    file_put_contents("data/$chatid/state.txt", "none");
    
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "❌ ورود نماد لغو شد",
        'reply_markup' => $menu
    ]);
}
elseif($data == "set_candle_limit") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 تعداد کندل مورد نیاز برای تحلیل را انتخاب کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "۵۰ کندل", 'callback_data' => "cl_50"]],
                [['text' => "۱۰۰ کندل", 'callback_data' => "cl_100"]],
                [['text' => "۲۰۰ کندل", 'callback_data' => "cl_200"]],
                [['text' => "۵۰۰ کندل", 'callback_data' => "cl_500"]],
                [['text' => "سفارشی ✏️", 'callback_data' => "cl_custom"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "ai_advanced_analysis"]]
            ]
        ])
    ]);
}
elseif ($data == "zigzag_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Zig Zag\n\n📌 مقدار پیش‌فرض تغییرات: 5%\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 5%", 'callback_data' => "confirm_zigzag_5"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}

elseif ($data == "confirm_zigzag_5") {
    file_put_contents("data/{$chatid}/zigzag_threshold.txt", 5);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار Zig Zag روی ۵٪ تغییرات قیمت تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif(strpos($data, "cl_") === 0) {
    $limit = str_replace("cl_", "", $data);
    
    if($limit == "custom") {
        file_put_contents("data/$chatid/state.txt", "await_candle_limit");
        bot('editMessagetext',[
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "🔢 لطفا تعداد کندل مورد نظر را وارد کنید (۱۰-۱۰۰۰):",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "❌ لغو", 'callback_data' => "cancel_limit"]]
                ]
            ])
        ]);
    } else {
        file_put_contents("data/$chatid/candle_limit.txt", $limit);
        bot('editMessagetext',[
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "✅ تعداد کندل روی $limit تنظیم شد",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "↩️ بازگشت به تحلیل", 'callback_data' => "ai_advanced_analysis"]]
                ]
            ])
        ]);
    }
}
elseif($state == "await_candle_limit") {
    if(!is_numeric($text) || $text < 10 || $text > 1000) {
        bot('sendMessage',[
            'chat_id' => $chatid,
            'text' => "❌ مقدار نامعتبر! عدد بین ۱۰ تا ۱۰۰۰ وارد کنید"
        ]);
        return;
    }
    
    file_put_contents("data/$chatid/candle_limit.txt", $text);
    file_put_contents("data/$chatid/state.txt", "none");
    
    bot('sendMessage',[
        'chat_id' => $chatid,
        'text' => "✅ تعداد کندل سفارشی $text ثبت شد",
        'reply_markup' => $menu
    ]);
}
elseif(strpos($data, "tf_") === 0) {
    $timeframe = str_replace("tf_", "", $data);
    
    if($timeframe == "custom") {
        file_put_contents("data/$chatid/state.txt", "await_custom_tf");
        bot('editMessagetext',[
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "✏️ تایم فریم سفارشی را وارد کنید (مثال: 30m, 2h, 1d):",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "❌ لغو", 'callback_data' => "cancel_timeframe"]]
                ]
            ])
        ]);
    } else {
        // ذخیره تایم فریم استاندارد
        file_put_contents("data/$chatid/timeframe.txt", $timeframe);
        bot('editMessagetext',[
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "✅ تایم فریم روی $timeframe تنظیم شد",
            'reply_markup' => $menu
        ]);
    }
}
elseif($state == "await_custom_tf") {
    $validFormats = ['m' => 1, 'h' => 60, 'd' => 1440];
    preg_match('/(\d+)([mhd])/', $text, $matches);
    
    if(!$matches || !in_array($matches[2], array_keys($validFormats))) {
        bot('sendMessage',[
            'chat_id' => $chatid,
            'text' => "❌ فرمت نامعتبر!\nمثال‌های صحیح: 15m, 2h, 1d"
        ]);
        return;
    }
    
    $value = (int)$matches[1];
    $unit = $matches[2];
    
    // محدودیت‌های بایننس برای تایم فریم
    if(($unit == 'm' && ($value < 1 || $value > 43200)) || 
       ($unit == 'h' && ($value < 1 || $value > 720)) ||
       ($unit == 'd' && ($value < 1 || $value > 365))) {
        bot('sendMessage',[
            'chat_id' => $chatid,
            'text' => "⚠️ مقدار خارج از محدوده مجاز!\n(۱m-43200m / ۱h-720h / ۱d-365d)"
        ]);
        return;
    }
    
    file_put_contents("data/$chatid/timeframe.txt", $text);
    bot('sendMessage',[
        'chat_id' => $chatid,
        'text' => "✅ تایم فریم سفارشی $text ثبت شد"
    ]);
}
elseif($data == "set_bollinger_params") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⚙️ *تنظیمات Bollinger Bands*\n\nپارامترها را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "دوره (20)", 'callback_data' => "bollinger_period_20"]],
                [['text' => "انحراف (2)", 'callback_data' => "bollinger_deviation_2"]],
                [['text' => "سفارشی ✏️", 'callback_data' => "bollinger_custom"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back_indicators"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "bollinger_") === 0) {
    if(strpos($data, "period_") !== false) {
        $period = str_replace("bollinger_period_", "", $data);
        file_put_contents("data/$chatid/bollinger_period.txt", $period);
    } elseif(strpos($data, "deviation_") !== false) {
        $deviation = str_replace("bollinger_deviation_", "", $data);
        file_put_contents("data/$chatid/bollinger_deviation.txt", $deviation);
    }
    
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✅ تنظیمات Bollinger Bands ذخیره شد",
        'reply_markup' => $menu
    ]);
}
elseif($data == "set_macd_params") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⚙️ *تنظیمات MACD*\n\nپارامترها را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "EMA سریع (12)", 'callback_data' => "macd_fast_12"]],
                [['text' => "EMA کند (26)", 'callback_data' => "macd_slow_26"]],
                [['text' => "Signal (9)", 'callback_data' => "macd_signal_9"]],
                [['text' => "سفارشی ✏️", 'callback_data' => "macd_custom"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back_indicators"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "macd_") === 0) {
    if(strpos($data, "fast_") !== false) {
        $fastPeriod = str_replace("macd_fast_", "", $data);
        file_put_contents("data/$chatid/macd_fast.txt", $fastPeriod);
    } elseif(strpos($data, "slow_") !== false) {
        $slowPeriod = str_replace("macd_slow_", "", $data);
        file_put_contents("data/$chatid/macd_slow.txt", $slowPeriod);
    } elseif(strpos($data, "signal_") !== false) {
        $signalPeriod = str_replace("macd_signal_", "", $data);
        file_put_contents("data/$chatid/macd_signal.txt", $signalPeriod);
    }
    
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✅ تنظیمات MACD ذخیره شد",
        'reply_markup' => $menu
    ]);
}
elseif($data == "set_ichimoku_params") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⚙️ *تنظیمات ایچیموکو*\n\nپارامترها را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "تنکان سن (9)", 'callback_data' => "ichimoku_tenkan_9"]],
                [['text' => "کیجون سن (26)", 'callback_data' => "ichimoku_kijun_26"]],
                [['text' => "سنکو اسپن B (52)", 'callback_data' => "ichimoku_senkou_b_52"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back_indicators"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "ichimoku_") === 0) {
    if(strpos($data, "tenkan_") !== false) {
        $tenkanPeriod = str_replace("ichimoku_tenkan_", "", $data);
        file_put_contents("data/$chatid/ichimoku_tenkan.txt", $tenkanPeriod);
    } elseif(strpos($data, "kijun_") !== false) {
        $kijunPeriod = str_replace("ichimoku_kijun_", "", $data);
        file_put_contents("data/$chatid/ichimoku_kijun.txt", $kijunPeriod);
    } elseif(strpos($data, "senkou_b_") !== false) {
        $senkouBPeriod = str_replace("ichimoku_senkou_b_", "", $data);
        file_put_contents("data/$chatid/ichimoku_senkou_b.txt", $senkouBPeriod);
    }
    
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✅ تنظیمات ایچیموکو ذخیره شد",
        'reply_markup' => $menu
    ]);
}
elseif($data == "set_atr_adx_params") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⚙️ *تنظیمات ATR و ADX*\n\nپارامترها را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "دوره ATR (14)", 'callback_data' => "atr_period_14"]],
                [['text' => "دوره ADX (14)", 'callback_data' => "adx_period_14"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "indicators_menu"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "atr_period_") === 0) {
    $atrPeriod = str_replace("atr_period_", "", $data);
    file_put_contents("data/$chatid/atr_period.txt", $atrPeriod);
} elseif(strpos($data, "adx_period_") === 0) {
    $adxPeriod = str_replace("adx_period_", "", $data);
    file_put_contents("data/$chatid/adx_period.txt", $adxPeriod);
}
elseif($data == "set_keltner_params") {
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⚙️ *تنظیمات کانال کلتنر*\n\nپارامترها را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "EMA دوره (20)", 'callback_data' => "keltner_ema_20"]],
                [['text' => "ATR دوره (10)", 'callback_data' => "keltner_atr_10"]],
                [['text' => "ضریب ATR (2)", 'callback_data' => "keltner_multiplier_2"]],
                [['text' => "سفارشی ✏️", 'callback_data' => "keltner_custom"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back_indicators"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "keltner_") === 0) {
    if (strpos($data, "ema_") !== false) {
        $emaPeriod = (int) str_replace("keltner_ema_", "", $data);
        file_put_contents("data/{$chatid}/keltner_ema.txt", $emaPeriod);
    } elseif (strpos($data, "atr_") !== false) {
        $atrPeriod = (int) str_replace("keltner_atr_", "", $data);
        file_put_contents("data/{$chatid}/keltner_atr.txt", $atrPeriod);
    } elseif (strpos($data, "multiplier_") !== false) {
        $multiplier = (int) str_replace("keltner_multiplier_", "", $data);
        file_put_contents("data/{$chatid}/keltner_multiplier.txt", $multiplier);
    }

    // ارسال تأییدیه
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✅ تنظیمات کانال کلتنر ذخیره شد!",
        'reply_markup' => $menu
    ]);
}
elseif($data == "set_parabolic_sar_params") {
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⚙️ *تنظیمات Parabolic SAR*\n\nپارامترها را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "AF شروع (۰.۰۲)", 'callback_data' => "sar_af_start_0.02"]],
                [['text' => "افزایش AF (۰.۰۲)", 'callback_data' => "sar_af_inc_0.02"]],
                [['text' => "حداکثر AF (۰.۲۰)", 'callback_data' => "sar_af_max_0.20"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back_indicators"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "sar_af_") === 0) {
    $parts = explode("_", $data);
    $paramType = $parts[2]; // start/inc/max
    $value = (float) $parts[3];
    
    if ($value > 0) {
        file_put_contents("data/{$chatid}/sar_af_{$paramType}.txt", $value);
    } else {
        bot('answerCallbackQuery', [
            'callback_query_id' => $callback_query_id,
            'text' => "❌ مقدار نامعتبر!",
            'show_alert' => true
        ]);
    }
    
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "✅ تنظیمات SAR ذخیره شد!",
        'reply_markup' => $menu
    ]);
}
elseif($data == "set_donchian_params") {
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "⚙️ *تنظیمات Donchian Channels*\n\nپارامترها را انتخاب کنید:",
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "دوره (20)", 'callback_data' => "donchian_period_20"]],
                [['text' => "سفارشی ✏️", 'callback_data' => "donchian_custom"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "back_indicators"]]
            ]
        ])
    ]);
}
elseif(strpos($data, "donchian_period_") === 0) {
    $period = (int) str_replace("donchian_period_", "", $data);
    
    if ($period > 0) {
        file_put_contents("data/{$chatid}/donchian_period.txt", $period);
        bot('editMessageText', [
            'chat_id' => $chatid,
            'message_id' => $messageid,
            'text' => "✅ دوره Donchian روی {$period} تنظیم شد!",
            'reply_markup' => $menu
        ]);
    } else {
        bot('answerCallbackQuery', [
            'callback_query_id' => $callback_query_id,
            'text' => "❌ مقدار دوره نامعتبر!",
            'show_alert' => true
        ]);
    }
}
elseif ($data == "cci_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات CCI\n\n📌 مقدار پیش‌فرض: 20\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 20", 'callback_data' => "confirm_cci_20"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif ($data == "confirm_cci_20") {
    file_put_contents("data/{$chatid}/cci_period.txt", 20);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار CCI روی ۲۰ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "stochastic_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Stochastic\n\n📌 مقدار پیش‌فرض: 14\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 14", 'callback_data' => "confirm_stochastic_14"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}

elseif ($data == "confirm_stochastic_14") {
    file_put_contents("data/{$chatid}/stochastic_period.txt", 14);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار Stochastic روی ۱۴ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "roc_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات ROC\n\n📌 مقدار پیش‌فرض: 14\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 14", 'callback_data' => "confirm_roc_14"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}

elseif ($data == "confirm_roc_14") {
    file_put_contents("data/{$chatid}/roc_period.txt", 14);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار ROC روی ۱۴ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "pivot") {
    file_put_contents("data/$chatid/state.txt", "pivot");
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "📊 اندیکاتور Pivot Points انتخاب شد. لطفاً ارز و تایم‌فریم موردنظر را وارد کنید.",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "ppo") {
    file_put_contents("data/$chatid/state.txt", "ppo");
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "📊 اندیکاتور PPO انتخاب شد. لطفاً ارز و تایم‌فریم موردنظر را وارد کنید.",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "ppo") {
    file_put_contents("data/$chatid/state.txt", "ppo");
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "📊 اندیکاتور PPO انتخاب شد. لطفاً ارز و تایم‌فریم موردنظر را وارد کنید.",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "moving_median_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Moving Median\n\n📌 مقدار پیش‌فرض: 20\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 20", 'callback_data' => "confirm_moving_median_20"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif ($data == "confirm_moving_median_20") {
    file_put_contents("data/{$chatid}/moving_median_period.txt", 20);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار Moving Median روی ۲۰ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "fibonacci") {
    file_put_contents("data/$chatid/state.txt", "fibonacci");
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "📊 اندیکاتور Fibonacci انتخاب شد. لطفاً ارز و تایم‌فریم موردنظر را وارد کنید.",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "williams_r_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Williams %R\n\n📌 مقدار پیش‌فرض: 14\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 14", 'callback_data' => "confirm_williams_r_14"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif ($data == "confirm_williams_r_14") {
    file_put_contents("data/{$chatid}/williams_r_period.txt", 14);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار Williams %R روی ۱۴ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "vwap") {
    file_put_contents("data/$chatid/state.txt", "vwap");
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "📊 اندیکاتور VWAP انتخاب شد. لطفاً ارز و تایم‌فریم موردنظر را وارد کنید.",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "mfi_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات MFI\n\n📌 مقدار پیش‌فرض: 14\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 14", 'callback_data' => "confirm_mfi_14"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}

elseif ($data == "confirm_mfi_14") {
    file_put_contents("data/{$chatid}/mfi_period.txt", 14);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار MFI روی ۱۴ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "obv") {
    file_put_contents("data/$chatid/state.txt", "obv");
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "📊 اندیکاتور OBV انتخاب شد. لطفاً ارز و تایم‌فریم موردنظر را وارد کنید.",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "rsi3") {
    file_put_contents("data/$chatid/state.txt", "obv");
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "📊 اندیکاتور RSI انتخاب شد. لطفاً ارز و تایم‌فریم موردنظر را وارد کنید.",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "fisher_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Fisher Transform\n\n📌 مقدار پیش‌فرض: 10\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 10", 'callback_data' => "confirm_fisher_10"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif ($data == "gann_fan_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Gann Fan\n\n📌 مقدار پیش‌فرض: آخرین 50 کندل\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 50", 'callback_data' => "confirm_gann_fan_50"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}

elseif ($data == "confirm_gann_fan_50") {
    file_put_contents("data/{$chatid}/gann_fan_period.txt", 50);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار Gann Fan روی ۵۰ کندل اخیر تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "confirm_fisher_10") {
    file_put_contents("data/{$chatid}/fisher_period.txt", 10);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار Fisher Transform روی ۱۰ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "heikin_ashi") {
    file_put_contents("data/$chatid/state.txt", "heikin_ashi");
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "📊 اندیکاتور Heikin Ashi Smoothed انتخاب شد. لطفاً ارز و تایم‌فریم موردنظر را وارد کنید.",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "rvi_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات RVI\n\n📌 مقدار پیش‌فرض: 10\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 10", 'callback_data' => "confirm_rvi_10"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}

elseif ($data == "confirm_rvi_10") {
    file_put_contents("data/{$chatid}/rvi_period.txt", 10);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار RVI روی ۱۰ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif ($data == "stc_settings") {
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات STC\n\n📌 مقدار پیش‌فرض: 10\n\nبرای تأیید این مقدار، روی دکمه زیر کلیک کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ تأیید مقدار 10", 'callback_data' => "confirm_stc_10"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back"]]
            ]
        ])
    ]);
}
elseif ($data == "hv_settings") {
    $currentHVPeriod = file_exists("data/{$chatid}/hv_period.txt") 
        ? (int) file_get_contents("data/{$chatid}/hv_period.txt") 
        : 20;

    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "🔧 تنظیمات Historical Volatility (HV)\n\n📌 مقدار فعلی: $currentHVPeriod روز\n\nلطفاً مقدار جدید را انتخاب کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ 10 روز", 'callback_data' => "set_hv_10"]],
                [['text' => "✅ 20 روز (پیش‌فرض)", 'callback_data' => "set_hv_20"]],
                [['text' => "✅ 30 روز", 'callback_data' => "set_hv_30"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "settings_menu"]]
            ]
        ]),
        'parse_mode' => "Markdown"
    ]);
}
elseif (in_array($data, ["set_hv_10", "set_hv_20", "set_hv_30"])) {
    $hvPeriod = (int) str_replace("set_hv_", "", $data);
    file_put_contents("data/{$chatid}/hv_period.txt", $hvPeriod);

    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار Historical Volatility روی $hvPeriod روز تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $settings_menu
    ]);
}
elseif ($data == "confirm_stc_10") {
    file_put_contents("data/{$chatid}/stc_period.txt", 10);
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => "✅ مقدار STC روی ۱۰ تنظیم شد.",
        'parse_mode' => "Markdown",
        'reply_markup' => $back2menu
    ]);
}
elseif($data == "ai_3") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 لطفا پارامترهای تحلیل را تنظیم کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "هوش مصنوعی کریپتو 📊", 'callback_data' => "ai_c"]],
                [['text' => "هوش مصنوعی فارکس 📊", 'callback_data' => "ai_forex"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "ai_analysis"]]
            ]
        ])
    ]);
}
elseif($data == "ai_c") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 لطفا پارامترهای تحلیل را تنظیم کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "ارسال درخواست به API 📡", 'callback_data' => "ai_c_ask"]],
                [['text' => "نمایش جواب هوش مصنوعی 📝", 'callback_data' => "showai_canswer"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "ai_analysis"]]
            ]
        ])
    ]);
}
elseif($data == "ai_forex") {
    bot('editMessagetext',[
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 لطفا پارامترهای تحلیل را تنظیم کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "ارسال درخواست به API 📡", 'callback_data' => "aifask"]],
                [['text' => "نمایش جواب هوش مصنوعی 📝", 'callback_data' => "showaifanswer"]],
                [['text' => "بازگشت ↩️", 'callback_data' => "ai_analysis"]]
            ]
        ])
    ]);
}
if ($data == "ai_c_ask") {
    try {
        $prompt = <<<PROMPT
لطفاً یک تحلیل جامع و دقیق ارائه دهید که شامل موارد زیر باشد:

📊 نوسانات 24 ساعته: تغییرات BTC/ETH + بیشترین نوسانات آلت‌کوین‌ها (Top 3)
💰 حجم معاملات: حجم معاملات BTC (USDT) + تغییرات 6 ساعته
📈 شاخص ترس و طمع: مقدار فعلی + تغییرات هفتگی + مقایسه با میانگین 30 روزه
🚀 حرکات آلت‌کوین‌ها: 5 رمزارز با بهترین عملکرد هفتگی + پروژه‌های با اخبار فاندامنتال قوی

✅ تحلیل به‌صورت بولت‌پوینت و دقیق باشد.
✅ از منابع آماری معتبر استفاده کنید.
✅ نتیجه‌گیری کوتاه‌مدت از روند بازار ارائه دهید.
PROMPT;

        // ذخیره پرامپت در فایل لاگ
        file_put_contents("data/$chatid/ai_prompts.log", "[".date('Y-m-d H:i:s')."] Prompt:\n$prompt\n\n", FILE_APPEND);
        
        // دریافت پاسخ از API
        $analysisResult = askDeepSeek($prompt, $deepseekApiKey);

        // ذخیره پاسخ خام در فایل JSON (بدون پردازش اضافی)
        $jsonFilePath = "data/$chatid/ai_answer.json";
        file_put_contents($jsonFilePath, json_encode($analysisResult, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        
        // خواندن و ارسال محتوای JSON به‌عنوان متن ساده
        $formattedText = file_get_contents($jsonFilePath);
        
        if ($formattedText !== false) {
            bot('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $messageId,
                'text' => "📢 تحلیل بازار:\n\n" . $formattedText,
                'parse_mode' => 'HTML', // حذف Markdown
                'reply_markup' => $keyboard
            ]);
            
            // لاگ موفقیت
            file_put_contents("data/$chatid/ai_success.log", "پیام ارسال شد: ".date('Y-m-d H:i:s')."\n", FILE_APPEND);
        } else {
            throw new Exception("خطا در خواندن فایل JSON پاسخ");
        }
        
    } catch (Exception $e) {
        // ذخیره خطا در فایل
        $errorMessage = "[".date('Y-m-d H:i:s')."] Error: ".$e->getMessage()."\n";
        file_put_contents("data/$chatid/ai_errors.log", $errorMessage, FILE_APPEND);
        
        bot('editMessageText', [
            'chat_id' => $chatId,
            'message_id' => $messageId,
            'text' => "⚠️ خطا: ".$e->getMessage(),
            'reply_markup' => $errorKeyboard
        ]);
    }
}
if ($data == "aifask") {
    try {
        // خواندن پرامپت از فایل
        $promptFile = "data/$chatid/promp.txt";
        $prompt = file_get_contents($promptFile);
        
        if ($prompt === false) {
            throw new Exception("خطا در خواندن پرامپت از مسیر: $promptFile");
        }
        // ذخیره پرامپت در فایل لاگ
        file_put_contents("data/$chatid/ai_promptsforex.log", "[".date('Y-m-d H:i:s')."] Prompt:\n$prompt\n\n", FILE_APPEND);
        
        // دریافت پاسخ از API
        $analysisResult = askDeepSeek($prompt, $deepseekApiKey);

        // ذخیره پاسخ خام در فایل JSON (بدون پردازش اضافی)
        $jsonFilePath = "data/$chatid/ai_answerforex.json";
        file_put_contents($jsonFilePath, json_encode($analysisResult, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        
        // خواندن و ارسال محتوای JSON به‌عنوان متن ساده
        $formattedText = file_get_contents($jsonFilePath);
        
        if ($formattedText !== false) {
            bot('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $messageId,
                'text' => "📢 تحلیل بازار:\n\n" . $formattedText,
                'parse_mode' => 'HTML', // حذف Markdown
                'reply_markup' => $keyboard
            ]);
            
            // لاگ موفقیت
            file_put_contents("data/$chatid/ai_successforex.log", "پیام ارسال شد: ".date('Y-m-d H:i:s')."\n", FILE_APPEND);
        } else {
            throw new Exception("خطا در خواندن فایل JSON پاسخ");
        }
        
    } catch (Exception $e) {
        // ذخیره خطا در فایل
        $errorMessage = "[".date('Y-m-d H:i:s')."] Error: ".$e->getMessage()."\n";
        file_put_contents("data/$chatid/ai_errorsforex.log", $errorMessage, FILE_APPEND);
        
        bot('editMessageText', [
            'chat_id' => $chatId,
            'message_id' => $messageId,
            'text' => "⚠️ خطا: ".$e->getMessage(),
            'reply_markup' => $errorKeyboard
        ]);
    }
}
elseif($data == "showai_canswer") {
    $filePath = "data/{$chatid}/ai_answer.json";
    
    if(file_exists($filePath)) {
        $content = file_get_contents($filePath);
        
        if(!empty(trim($content))) {
            bot('editMessageText',[
                'chat_id' => $chatid,
                'message_id' => $messageid,
                'text' => "📝 پاسخ هوش مصنوعی:\n\n" . $content,
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
                    ]
                ])
            ]);
        } else {
            bot('answerCallbackQuery',[
                'callback_query_id' => $callback_query_id,
                'text' => "⚠️ هیچ پاسخی موجود نیست!",
                'show_alert' => true
            ]);
        }
    } else {
        bot('answerCallbackQuery',[
            'callback_query_id' => $callback_query_id,
            'text' => "❌ فایل پاسخ یافت نشد!",
            'show_alert' => true
        ]);
    }
}
elseif ($data == "airdrop_menu") {
    $userFile = "data/$chatid/user_data.json";
    $userData = file_exists($userFile) ? json_decode(file_get_contents($userFile), true) : ['referrals' => 0, 'coins' => 0];
    
    $text = "💰 *ایردراپ رایگان*\n\n";
    $text .= "👥 تعداد زیرمجموعه‌ها: " . $userData['referrals'] . "\n";
    $text .= "💎 سکه‌های شما: " . $userData['coins'] . "\n";
    $text .= "📌 برای برداشت " . AIRDROP_TOKEN_AMOUNT . " توکن، حداقل " . AIRDROP_REFERRAL_MIN . " زیرمجموعه نیاز است.";
    
    $keyboard = [];
    if ($userData['referrals'] >= AIRDROP_REFERRAL_MIN) {
        $keyboard[] = [['text' => "📤 درخواست برداشت", 'callback_data' => "request_withdrawal"]];
    }
    $keyboard[] = [['text' => "🔙 بازگشت", 'callback_data' => "back"]];
    
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => $text,
        'parse_mode' => "Markdown",
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}

elseif ($data == "request_withdrawal") {
    file_put_contents("data/$chatid/state.txt", "await_wallet_address");
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📮 لطفاً آدرس ولت BSC خود را وارد کنید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "❌ لغو", 'callback_data' => "cancel_withdrawal"]]
            ]
        ])
    ]);
}
if ($state == "await_wallet_address" && isset($text)) {
    if (preg_match('/^0x[a-fA-F0-9]{40}$/', $text)) { // اعتبارسنجی آدرس BSC
        $userFile = "data/$chatid/user_data.json";
        if (!file_exists($userFile)) {
            bot('sendMessage', [
                'chat_id' => $chatid,
                'text' => "❌ فایل داده کاربر یافت نشد! لطفاً با پشتیبانی تماس بگیرید."
            ]);
            file_put_contents("data/$chatid/state.txt", "none");
            return;
        }

        $userData = json_decode(file_get_contents($userFile), true);
        
        if ($userData['referrals'] >= AIRDROP_REFERRAL_MIN) {
            $channelChatId = "@shanimony"; // جایگزین کنید با نام کاربری کانال یا آیدی عددی (مثلاً -1001234567890)

            $requestMessage = "📤 درخواست برداشت جدید:\n";
            $requestMessage .= "👤 کاربر: $chatid\n";
            $requestMessage .= "👥 زیرمجموعه‌ها: " . $userData['referrals'] . "\n";
            $requestMessage .= "💰 مقدار: " . AIRDROP_TOKEN_AMOUNT . " توکن\n";
            $requestMessage .= "📮 آدرس ولت: $text";

            // ارسال پیام به کانال
            $response = bot('sendMessage', [
                'chat_id' => $channelChatId,
                'text' => $requestMessage
            ]);

            // بررسی موفقیت ارسال پیام
            if ($response && isset($response->ok) && $response->ok) {
                // کسر زیرمجموعه‌ها و به‌روزرسانی داده‌ها
                $userData['referrals'] -= AIRDROP_REFERRAL_MIN;
                $userData['coins'] -= AIRDROP_REFERRAL_MIN * 100; // فرض: هر زیرمجموعه ۱۰۰ سکه
                file_put_contents($userFile, json_encode($userData));

                bot('sendMessage', [
                    'chat_id' => $chatid,
                    'text' => "✅ درخواست برداشت شما ثبت شد و به کانال ارسال شد.\nپس از تأیید، توکن‌ها به ولت شما واریز می‌شود.",
                    'reply_markup' => $menu
                ]);
            } else {
                $error = isset($response->description) ? $response->description : "خطای ناشناخته";
                bot('sendMessage', [
                    'chat_id' => $chatid,
                    'text' => "❌ خطا در ارسال درخواست به کانال: $error"
                ]);
                error_log("Failed to send message to channel: " . json_encode($response), 3, "data/errors.log");
            }
        } else {
            bot('sendMessage', [
                'chat_id' => $chatid,
                'text' => "❌ تعداد زیرمجموعه‌های شما کافی نیست! حداقل " . AIRDROP_REFERRAL_MIN . " زیرمجموعه نیاز است."
            ]);
        }
    } else {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ آدرس ولت نامعتبر است! لطفاً یک آدرس BSC معتبر وارد کنید (مثال: 0x123...). آدرس شما: $text"
        ]);
    }
    file_put_contents("data/$chatid/state.txt", "none");
}
elseif ($data == "cancel_withdrawal") {
    file_put_contents("data/$chatid/state.txt", "none");
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "❌ درخواست برداشت لغو شد.",
        'reply_markup' => $menu
    ]);
}

// مدیریت دریافت آدرس ولت و پردازش خرید
if ($state && preg_match('/await_wallet_for_nft_(\d+)/', $state, $matches) && isset($text)) {
    $nftIndex = $matches[1];
    if (preg_match('/^0x[a-fA-F0-9]{40}$/', $text)) {
        $userFile = "data/$chatid/user_data.json";
        $userData = file_exists($userFile) ? json_decode(file_get_contents($userFile), true) : ['coins' => 0];
        $price = 1000;

        if ($userData['coins'] >= $price) {
            $userData['coins'] -= $price;
            file_put_contents($userFile, json_encode($userData));

            // ثبت تراکنش (می‌توانید به دیتابیس یا فایل لاگ اضافه کنید)
            $transactionLog = "data/transactions.log";
            $logEntry = "[" . date('Y-m-d H:i:s') . "] User $chatid bought NFT #$nftIndex for $price tokens. Wallet: $text\n";
            file_put_contents($transactionLog, $logEntry, FILE_APPEND);

            bot('sendMessage', [
                'chat_id' => $chatid,
                'text' => "✅ خرید NFT #$nftIndex با موفقیت انجام شد!\nآدرس ولت شما: $text\nتوکن‌ها از حساب شما کسر شد.",
                'reply_markup' => $menu
            ]);

            // ارسال تأییدیه به کانال (اختیاری)
            $channelChatId = "@shanimony";
            bot('sendMessage', [
                'chat_id' => $channelChatId,
                'text' => "📦 خرید جدید NFT:\n👤 کاربر: $chatid\n🎨 NFT #$nftIndex\n💰 قیمت: $price توکن\n📮 ولت: $text"
            ]);
        } else {
            bot('sendMessage', [
                'chat_id' => $chatid,
                'text' => "❌ موجودی شما کافی نیست!"
            ]);
        }
    } else {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ آدرس ولت نامعتبر است! لطفاً یک آدرس BSC معتبر وارد کنید."
        ]);
    }
    file_put_contents("data/$chatid/state.txt", "none");
}

// اضافه کردن گزینه منو به کد اصلی
elseif ($data == "nft_shop") {
    showNFTShopMenu($chatid, $messageid);
}

// مدیریت لغو خرید
elseif ($data == "cancel_nft_purchase") {
    file_put_contents("data/$chatid/state.txt", "none");
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "❌ خرید NFT لغو شد.",
        'reply_markup' => $menu
    ]);
}

// مدیریت بازگشت به منو
elseif ($data == "back_to_menu") {
    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📍 منوی اصلی",
        'reply_markup' => $menu
    ]);
}
elseif (preg_match('/buy_nft_(\d+)/', $data, $matches)) {
    $nftIndex = $matches[1];
    $nftFolder = __DIR__ . '/NFT/';
    $nftFiles = array_diff(scandir($nftFolder), ['..', '.']);
    $nftList = array_filter($nftFiles, fn($file) => in_array(strtolower(pathinfo($file, PATHINFO_EXTENSION)), ['png', 'jpg', 'jpeg']));

    $nftList = array_values($nftList); // بازنشانی ایندکس‌ها

    if (isset($nftList[$nftIndex])) {
        $nftName = pathinfo($nftList[$nftIndex], PATHINFO_FILENAME);
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "🎉 شما روی خرید NFT #$nftIndex ($nftName) کلیک کردید!\nلطفاً صبر کنید...",
        ]);
        handleNFTPurchase($chatid, $messageid, $data);
    } else {
        bot('sendMessage', [
            'chat_id' => $chatid,
            'text' => "❌ NFT انتخاب‌شده یافت نشد!"
        ]);
    }
}
elseif($data == "showaifanswer") {
    $filePath = "data/{$chatid}/ai_answerforex.json";
    
    if(file_exists($filePath)) {
        $content = file_get_contents($filePath);
        
        if(!empty(trim($content))) {
            bot('editMessageText',[
                'chat_id' => $chatid,
                'message_id' => $messageid,
                'text' => "📝 پاسخ هوش مصنوعی:\n\n" . $content,
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => "بازگشت ↩️", 'callback_data' => "back"]]
                    ]
                ])
            ]);
        } else {
            bot('answerCallbackQuery',[
                'callback_query_id' => $callback_query_id,
                'text' => "⚠️ هیچ پاسخی موجود نیست!",
                'show_alert' => true
            ]);
        }
    } else {
        bot('answerCallbackQuery',[
            'callback_query_id' => $callback_query_id,
            'text' => "❌ فایل پاسخ یافت نشد!",
            'show_alert' => true
        ]);
    }
}
elseif ($data == "take_screenshot") {
    $apiKey = 'ZD95XP7-WPK4P0W-HF7AFFD-XZS1Z8S'; // کلید API خود را اینجا قرار دهید
    $url = urlencode('https://pskdod.com'); // آدرس سایت موردنظر
    takeWebsiteScreenshotAPI($url, $chatid, $apiKey);

    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📸 درخواست اسکرین‌شات در حال پردازش است...",
        'reply_markup' => $menu
    ]);
}
elseif ($data == "market_stats") {
    fetchMarketStats($chatid);

    bot('editMessageText', [
        'chat_id' => $chatid,
        'message_id' => $messageid,
        'text' => "📊 اطلاعات بازار در حال بارگذاری است...",
        'reply_markup' => $menu
    ]);
}
// برای اجرای خودکار از cron
if (isset($argv[1]) && $argv[1] == 'cron') {
    // فقط تابع رو برای چنل اجرا کن
    fetchCNYRateFromJson('@sna_cny');
    exit; // برای جلوگیری از اجرای بقیه کد
}
?>