<?php
// تنظیمات API
$binance_api_url = "https://api.binance.com/api/v3/klines";

// بررسی درخواست
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $symbol = $_POST['symbol'] ?? 'BTCUSDT';
    $interval = $_POST['interval'] ?? '1h';
    $limit = $_POST['limit'] ?? 50;

    // دریافت اطلاعات کندل از بایننس
    $url = "$binance_api_url?symbol=$symbol&interval=$interval&limit=$limit";
    $response = file_get_contents($url);
    $data = json_decode($response, true);

    if ($data) {
        // پردازش قیمت‌های بسته شدن
        $closing_prices = array_column($data, 4);
        $highs = array_column($data, 2);
        $lows = array_column($data, 3);

        function calculate_sma($prices, $period = 20) {
            return array_sum(array_slice($prices, -$period)) / $period;
        }

        function calculate_ema($prices, $period = 20) {
            $k = 2 / ($period + 1);
            $ema = $prices[0];
            foreach ($prices as $price) {
                $ema = ($price * $k) + ($ema * (1 - $k));
            }
            return $ema;
        }

        function calculate_rsi($prices, $period = 14) {
            $gains = $losses = 0;
            for ($i = 1; $i < $period; $i++) {
                $change = $prices[$i] - $prices[$i - 1];
                if ($change > 0) $gains += $change;
                else $losses += abs($change);
            }
            if ($losses == 0) return 100;
            $rs = $gains / $losses;
            return 100 - (100 / (1 + $rs));
        }

        function calculate_macd($prices, $short_period = 12, $long_period = 26, $signal_period = 9) {
            $short_ema = calculate_ema($prices, $short_period);
            $long_ema = calculate_ema($prices, $long_period);
            $macd_line = $short_ema - $long_ema;
            $signal_line = calculate_ema([$macd_line], $signal_period);
            return $macd_line - $signal_line;
        }

        function calculate_bollinger_bands($prices, $period = 20, $std_dev = 2) {
            $sma = calculate_sma($prices, $period);
            $sum = 0;
            foreach (array_slice($prices, -$period) as $price) {
                $sum += pow($price - $sma, 2);
            }
            $std = sqrt($sum / $period);
            return ['upper' => $sma + ($std_dev * $std), 'lower' => $sma - ($std_dev * $std)];
        }

        function calculate_cci($prices, $highs, $lows, $period = 20) {
            $typical_prices = [];
            for ($i = 0; $i < count($prices); $i++) {
                $typical_prices[] = ($highs[$i] + $lows[$i] + $prices[$i]) / 3;
            }
            $sma = calculate_sma($typical_prices, $period);
            $mean_dev = array_sum(array_map(fn($p) => abs($p - $sma), $typical_prices)) / $period;
            return ($typical_prices[count($typical_prices) - 1] - $sma) / (0.015 * $mean_dev);
        }

        function calculate_adx($highs, $lows, $prices, $period = 14) {
            $dx_values = [];
            for ($i = 1; $i < $period; $i++) {
                $tr = max($highs[$i] - $lows[$i], abs($highs[$i] - $prices[$i - 1]), abs($lows[$i] - $prices[$i - 1]));
                $plus_dm = $highs[$i] - $highs[$i - 1];
                $minus_dm = $lows[$i - 1] - $lows[$i];

                $plus_di = ($plus_dm > $minus_dm && $plus_dm > 0) ? ($plus_dm / $tr) * 100 : 0;
                $minus_di = ($minus_dm > $plus_dm && $minus_dm > 0) ? ($minus_dm / $tr) * 100 : 0;
                $dx_values[] = abs($plus_di - $minus_di) / ($plus_di + $minus_di) * 100;
            }
            return calculate_sma($dx_values, $period);
        }

        // اجرای اندیکاتورها
        $sma = calculate_sma($closing_prices);
        $ema = calculate_ema($closing_prices);
        $rsi = calculate_rsi($closing_prices);
        $macd = calculate_macd($closing_prices);
        $bollinger = calculate_bollinger_bands($closing_prices);
        $cci = calculate_cci($closing_prices, $highs, $lows);
        $adx = calculate_adx($highs, $lows, $closing_prices);
        // تصمیم‌گیری بر اساس شاخص‌ها
        $signal = "🔄 خنثی";
        if ($rsi < 30 && $macd > 0) $signal = "🔼 خرید";
        elseif ($rsi > 70 && $macd < 0) $signal = "🔽 فروش";

        echo json_encode([
            'symbol' => $symbol,
            'interval' => $interval,
            'last_price' => end($closing_prices),
            'sma' => round($sma, 2),
            'ema' => round($ema, 2),
            'rsi' => round($rsi, 2),
            'macd' => round($macd, 2),
            'bollinger_upper' => round($bollinger['upper'], 2),
            'bollinger_lower' => round($bollinger['lower'], 2),
            'cci' => round($cci, 2),
            'adx' => round($adx, 2),
            'signal' => $signal
        ]);
    } else {
        echo json_encode(['error' => 'خطا در دریافت داده‌ها']);
    }
}
?>